pro limbhamme,limb_table
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read Van Hamme's integrated limb darkening coefficients and return in table.
;
data=''
status=dc_read_fixed(!atmospheres_dir+'vanhamme/limb.dat',data,/col, $
	resize=[1],format='(a132)')
num_mod=408
num_bnd=17
num_rec=num_mod*num_bnd
;
band=strarr(num_rec)
ulin=fltarr(num_rec,/nozero)
teff=fltarr(num_rec,/nozero)
logg=fltarr(num_rec,/nozero)
;
record=0
n=0
for i=0,num_mod-1 do begin
	pos=strpos(data[record],'Teff')
	t_eff=float(strmid(data[record],pos+6,6))
	pos=strpos(data[record],'log g')
	log_g=float(strmid(data[record],pos+7,4))
	for j=record+1,record+num_bnd do begin
		band[n]=strmid(data[j],2,1)
		ulin[n]=float(strmid(data[j],8,5))
		teff[n]=t_eff
		logg[n]=log_g
		n=n+1
	endfor
	record=record+1+num_bnd
endfor
;
limb_table=alloc_limb_table(band,ulin,teff,logg)
;
end
