function limbmaps,model,lammda,num=num
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return an array of stellar disk maps for each wavelength using various
; limb darkening laws. Note: input lambda is in [nm].
;
common LimbBase,limb_data
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(limb_data) eq 0 then limbdata,/restore
;
; Find closest model
m=limbmodel(limb_data.m,limb_data.t,limb_data.g,model.teff,model.logg,/closest)
;
; Find the model data
index=where(limb_data.n eq m)
;
; Interpolate values for observed wavelengths
limbdu=interpol(limb_data.u[index],limb_data.w[index],lammda)
limbdx=interpol(limb_data.x[index],limb_data.w[index],lammda)
limbdy=interpol(limb_data.y[index],limb_data.w[index],lammda)
fluxes=interpol(limb_data.f[index],limb_data.w[index],lammda)
; limbdu=spline(limb_data.w(index),limb_data.u(index),lammda,10)
; limbdx=spline(limb_data.w(index),limb_data.x(index),lammda,10)
; limbdy=spline(limb_data.w(index),limb_data.y(index),lammda,10)
; fluxes=spline(limb_data.w(index),limb_data.f(index),lammda,10)
;
; Create a map with element identifications
if n_elements(num) eq 0 then num=33 	; must be odd number
num=2*(num/2)+1
map=indgen(num*num)
;
; Copy coordinates
xcc=float((map mod num)-(num-1)/2)/((num-1)/2)	; [-1,1]
ycc=float((map  /  num)-(num-1)/2)/((num-1)/2)	; [-1,1]
;
; Compute radius squared
rsq=xcc^2+ycc^2
;
; Use only the visible hemisphere
index=where(rsq lt 1,count)
rsq=rsq[index]
xcc=xcc[index]
ycc=ycc[index]
;
; Compute mu, the cosine of the angle between the LOS and the surface normal
mu=sqrt(1-rsq)
;
; Create array of to hold maps
map=alloc_map(count,lonarr(count),fltarr(count),fltarr(count),fltarr(count))
maps=replicate(map,n_elements(lammda))
;
for i=0,n_elements(lammda)-1 do begin
	case model.type of
	3:	begin
;		Linear limb darkening law
		fcc=fluxes[i]*(1-limbdu[i]*(1-mu))
		end
	4:	begin
;		Logarithmic limb darkening law
		fcc=fluxes[i]*(1-limbdx[i]*(1-mu)-limbdy[i]*mu*alog(mu))
		end
	5:	begin
;		Linear limb darkening law
		fcc=fluxes[i]*(1-limbdu[i]*(1-mu))
		end
	endcase
	maps[i].xcc=xcc*model.diameter/2
	maps[i].ycc=ycc*model.diameter/2
	maps[i].fcc=fcc
endfor
;
return,maps
;
end
