function limbmodel,m,t,g,teff,logg,teff_model,closest=closest
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the model number closest to teff and logg. Now modified to
; return two models bracketing requested Teff with closest in log(g).
;
common LocalLimbModel,model_old
;
if n_elements(closest) eq 0 then closest=0
;
if n_elements(model_old) eq 0 then model_old=-1
n=n_elements(m)
;
IF not closest THEN BEGIN
;
; Find closest bracketing models for Teff (closest in logg)
j=where(t le teff[0],count)
if count eq 0 then j=indgen(n)	; use closest if outside available range
d_t=abs(teff[0]-t[j])
jndex=where(d_t eq min(d_t))
k=where(g le logg[0])
k=indgen(n)		; just use closest for log(g)
d_g=abs(logg[0]-g[k])
kndex=where(d_g eq min(d_g))
i=whereequal(j[jndex],k[kndex])
i1=j[jndex[i]]
;
j=where(t ge teff[0],count)
if count eq 0 then j=indgen(n)	; use closest if outside available range
d_t=abs(teff[0]-t[j])
jndex=where(d_t eq min(d_t))
k=where(g ge logg[0])
k=indgen(n)		; just use closest for log(g)
d_g=abs(logg[0]-g[k])
kndex=where(d_g eq min(d_g))
i=whereequal(j[jndex],k[kndex])
i2=j[jndex[i]]
;
i=where(k[kndex[0]] eq model_old,count)
if count eq 0 and long(t[i1]) ne long(t[i2]) then begin
print,'Model: Teff [K] interpolated between ',long(t[i1]),',',long(t[i2]), $
		', log(g)=',g[k[kndex[0]]],format='(a,i5,a,i5,a,f3.1)'
model_old=[model_old,k[kndex[0]]]
endif
;
return,m[[i1,i2]]
;
ENDIF ELSE BEGIN
;
; Find closest model
d_t=abs(teff[0]-t)
d_g=abs(logg[0]-g)
index=where(d_t eq min(d_t)) & j=where(d_g[index] eq min(d_g[index])) & j=j[0]
teff_model=t[index[j]]
k=where(index[j] eq model_old,count)
if count eq 0 then begin
        print,'Using model: Teff=',long(teff_model), $
                       ', log(g)=',g[index[j]],format='(a,i5,a,f3.1)'
	model_old=[model_old,index[j]]
endif
return,m[index[j]]
;
ENDELSE
;
end
