pro list_bgscans
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,startable,notes
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if checkdata([2,3]) eq -1 then return
;
list_stars,stars
;
print,'Star    | BG Scans           '
;
max_per_line=11
;
for i=0,n_elements(stars)-1 do begin
	print,'--------|---------------------------------------------------------------
	j=where(startable.starid eq stars[i])
	index=where(ScanTable.starid eq stars[i],count)
	print,startable[j].starid,' | ',format='(a,a,$)'
	for k=0,count-1 do begin
		if k mod max_per_line eq 0 and k ne 0 then begin
			print,''
			print,'        |-------------------------------------------------------------
			print,'        | ',format='(a,$)'
		endif
		jndex=where(BGTable.scanid eq ScanTable[index[k]].scanid,n)
		for l=0,n-1 do print,BGTable[jndex[l]].iscan,' ',format='(i3,a,$)'
		if n eq 0 then space='    ' else space=''
		print,space,'| ',format='(a,a,$)'
	endfor
	print,''
endfor
print,'--------|----------------------------------------------------------------
;
end
