pro list_calentries
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
;
if n_elements(cal_entries) eq 0 then begin
	print,'***Error(LIST_CALENTRIES): no cal_entries defined!'
	return
endif
index=where(cal_entries.num_coeffs gt 0,count)
if count eq 0 then begin
	print,'***Error(LIST_CALENTRIES): cal_entries empty!'
	return
endif
entries=cal_entries[index]
print,'Number of valid entries in cal_entries:',n_elements(entries)
for i=0,n_elements(entries)-1 do begin
	print,entries[i].reason, $
		', OB=',entries[i].outbeam+1, $
		', BL=',entries[i].baseline+1, $
		', CH=',entries[i].channel+1, $
		', Stars=',entries[i].stars, $
		format='(a,a,i2,a,i2,a,i3,100a)'
endfor
print,'Listing complete.'
;
end
