pro list_flagreasons,class,reasons
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
reasons=''
if n_elements(class) eq 0 then begin
	print,'***Error(LIST_FLAGREASONS): no class defined!'
	return
endif
case class of
	'point':begin
		if n_elements(pointflagtable) eq 0 then return
		table=pointflagtable
		end
	'metro':begin
		if n_elements(inchflagtable) eq 0 then return
		table=inchflagtable
		end
	'bg'   :begin
		if n_elements(bgflagtable) eq 0 then return
		table=bgflagtable
		end
	'scan' :begin
		if n_elements(scanflagtable) eq 0 then return
		table=scanflagtable
		end
	   else:begin
		print,'***Error(LIST_FLAGREASONS): invalid class!'
		return
		end
endcase
index=where(table.time ge 0,count)
if count eq 0 then return
reasons=table[index].reason
reasons=reasons[uniq(reasons,sort(reasons))]
;
if n_params() eq 1 then print,reasons
;
end
