pro list_modcomp,component,method
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if n_elements(gen_model) eq 0 then return
if n_elements (component) eq 0 then return
;
; Always list all parameters
; method=0
;
print,'_______________________________________________________________'
index=where(binary_model.component eq component,count)
if count gt 0 then begin
	tags=tag_names(binary_model) & ntags=n_elements(tags)
	if method eq 0 then it=indgen(ntags)
	if method eq 1 then it=indgen(ntags-2)
	if method eq 2 then it=[0,1,2,3,13,14]
	for k=0,n_elements(it)-1 do begin
		i=it[k]
		if n_elements(binary_model[index].(i)) eq 1 then begin
			result=size(binary_model[index].(i))
			if result[n_elements(result)-2] eq 5 then $
			print,tags[i],'=',binary_model[index].(i), $
				  ' +/- ',binary_error[index].(i) else $
			print,tags[i],'=',binary_model[index].(i)
		endif else begin
			print,tags[i],'=',binary_model[index].(i)
			blank=' '
			for j=0,strlen(tags[i])-6 do blank=blank+' '
			print,blank+' +/- ',binary_error[index].(i)
		endelse
	endfor
endif
tcount=count
index=where(star_model.component eq component,count)
if count gt 0 then begin
	tags=tag_names(star_model)
	for i=0,n_elements(tags)-1 do begin
		if tags[i] eq 'SPOT' then begin
			if total(star_model[index].spot) eq 0 then continue
		endif
		if tags[i] eq 'SPOTPARMS' then begin
			if total(star_model[index].spotparms) eq 0 then continue
		endif
		if n_elements(star_model[index].(i)) eq 1 then begin
			result=size(star_model[index].(i))
			if result[n_elements(result)-2] eq 5 then $
			print,tags[i],'=',star_model[index].(i), $
		          	  ' +/- ',star_error[index].(i) else $
			print,tags[i],'=',star_model[index].(i)
		endif else begin
			print,tags[i],'=',star_model[index].(i)
			blank=' '
                        for j=0,strlen(tags[i])-6 do blank=blank+' '
			print,blank+' +/- ',star_error[index].(i)
		endelse
	endfor
endif
tcount=tcount+count
if tcount eq 0 then begin
	tags=tag_names(gen_model)
	for i=0,n_elements(tags)-1 do begin
		print,tags[i],'=',gen_model.(i)
		blank=' '
                for j=0,strlen(tags[i])-6 do blank=blank+' '
		print,blank+' +/- ',gen_error.(i)
	endfor
endif
print,'______________________________***______________________________'
;
end
