pro list_names,comp_names
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
if hds_state() eq 0 then begin
	print,'***Error(LIST_NAMES): no HDS file open!'
	return
endif
;
dat_shape,ndim,dims
;
; Check if object is primitive
dat_prim,reply
if reply eq 1 then begin
	print,'Object is primitive!'
	dat_type,type
	if ndim gt 0 then begin
	   	print,'Type=',type,', No. of dimensions=',ndim
		print,'Lengths=',dims[0:ndim-1]
	endif else print,'Type=',type,', Scalar'
	return
endif
;
if ndim eq 0 then begin
	dat_ncomp,n
	if n gt 0 then comp_names=strarr(n)
	for i=1,n do begin
		dat_index,i
		dat_name,name
		comp_names[i-1]=name
		dat_annul
	endfor
endif else if ndim eq 1 then begin
	comp_names=strarr(dims[0])
	for i=0,dims[0]-1 do comp_names[i]=string(format='(i4)',i+1)
endif else begin
	comp_names=elements(ndim,dims)
endelse
n=n_elements(comp_names)
if n_params() eq 0 then begin
	case ndim of
	0: for i=1,n do print,comp_names[i-1]
	1: print,'Array object: ',n,' elements!'
     else: print,'Array object: ',ndim,' dimensions!'
	endcase
endif
;
end
