pro list_note,starid,note
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Print notes for starid to screen or return as note.
;
common StarBase,StarTable,Notes
;
if n_elements(notes) eq 0 then begin
	print,'***Error(LIST_NOTE): notes not available!'
	return
endif
;
if n_elements(starid) eq 0 then begin
	print,'***Error(LIST_NOTE): stars undefined!'
	return
endif
;
if n_params() eq 1 then do_print=1 else do_print=0
;
note=''
separator='-----------------------------'
for i=0,n_elements(starid)-1 do begin
	index=where(strpos(notes,starid[i]) ne -1 $
		and strpos(shift(notes,1),separator) ne -1,count)
	if count ne 0 then begin
		if do_print then print,'_____________________________________________'
		j=index[0]
		while strpos(notes[j],separator) eq -1 do begin
			if do_print then print,notes[j]
			j=j+1
		endwhile
		if do_print then print,'____________________***______________________'
		note=[note,notes[index[0]:j-1]]
	endif
endfor
;
if n_elements(note) gt 1 then note=note[1:n_elements(note)-1]
;
end
