pro list_notes,starids
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return a list of stars for which notes are available.
;
common StarBase,StarTable,Notes
;
if n_elements(notes) eq 0 then begin
	print,'***Error(LIST_NOTES): notes not available!'
	return
endif
;
index=where(strpos(notes,'---------------------------') ne -1,count)
if count eq 0 then begin
	print,'***Error(LIST_NOTES): file corrupt!'
	return
endif
index=index+1
jndex=where(index lt n_elements(notes),count)
if count eq 0 then begin
	print,'***Error(LIST_NOTES): file corrupt!'
	return
endif
index=index[jndex]
starids=strarr(count)
for i=0,count-1 do begin
	pos=strpos(notes[index[i]],' ')
	if pos eq -1 then pos=strlen(notes[index[i]])
	starids[i]=strmid(notes[index[i]],0,pos)
endfor
;
if n_params() eq 0 then print,starids
;
end
