pro list_scans,jndex,coherent=coherent,track=track,name=name,starid=starid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; List the observed scans. Using the index argument, the list can be
; restricted to certain indices in the scantable, or all entries corresponding
; to a specific star (e.g. index='BSC1931'). In any case, the index argument
; will contain the final list on output, *overwriting* the input variable!
;
common Tables,ScanTable,BGTable,StationTable
common StarBase,StarTable,Notes
;
if checkdata([1]) ne 0 then return
;
if n_elements(track) eq 0 then track=0
if n_elements(coherent) eq 0 then coherent=0
;
starids=scantable.starid
names=starids
for i=0,n_elements(names)-1 do names[i]=startable[where(startable.starid eq star
;
if keyword_set(name) then begin
	starids=names
;	max_len=max(strlen(starids))
;	for i=0,n_elements(starids)-1 do starids(i)=starids(i)+blanks(max_len-strlen(s
endif else begin
;	index=where(strlen(starids) eq 7,count)
;	if count ge 1 then starids(index)=starids(index)+'  '
endelse
max_len=max(strlen(starids))
for i=0,n_elements(starids)-1 do starids[i]=starids[i]+blanks(max_len-strlen(sta
;
; help,jndex,level=-1,/full,output=o
; if strmid(o(0),0,9) eq '<No name>' then do_print=1 else do_print=0
if n_params() eq 1 and n_elements(jndex) eq 0 then do_print=0 else do_print=1
;
r=size(jndex)
if r[n_elements(r)-2] eq 7 then begin
	if valid_cat(jndex) then begin
; 	Input is star
		jndex=where(scantable.starid eq jndex,count)+1
	endif else begin
;	ID Input is a configuration ID
		jndex=scanconfig(jndex)
		count=n_elements(jndex)
	endelse
	if count eq 0 then return
endif
if n_elements(jndex) eq 0 then jndex=indgen(n_elements(scantable))+1
if coherent or track then begin
	cindex=where(scantable[jndex-1].code eq 1,count)
	if count eq 0 then return
	jndex=jndex[cindex]
endif
index=jndex-1
if max(index) lt 100 then iformat='(i2)' else iformat='(i3)'
;
if track then track_status=trackindex()+') '  $
	 else track_status=scanconfig(index+1)+', ' $
; In next line the "lonely" ' )' causes a error. It is now added by printout.
;			  +string(scantable(index).code,format='(i1)')+') '
			  +string(scantable[index].code,format='(i1)')
;
printout=strarr((n_elements(index)+1)/2,2)
printout[0:n_elements(index)-1]= $
; '('+string(index+1,format=iformat)+') '+scantable(index).starid $
'('+string(index+1,format=iformat)+') '+starids(index) $
     +' ('+strcompress(hms((scantable(index).starttime $
               +scantable(index).stoptime)/(2*3600),/scan),/remove_all) $
;    +', '+scanconfig(index+1) $
;    +', '+string(scantable(index).code,format='(i1)')+') '
;    +', '+track_status
     +', '+track_status+')'
if do_print then begin
	if track then begin
	print,'                          Tracking stations'
	print,'( #) Star      (Mean time, Base Triple)'
	endif
	print,transpose(printout),format='(2a)'
endif
;
end
