pro list_star,starids
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Print available information on specific star to screen. Star is identified
; by ID or name. Minimum match is implemented for names out of StarTable.name,
; var, and toe.
;
common StarBase,StarTable,Notes
;
if n_elements(StarTable) eq 0 then begin
	print,'***Error(LIST_STAR): StarTable does not exist!'
	return
endif
if n_elements(starids) eq 0 then begin
	if n_elements(StarTable) eq 1 then begin
		list_star,startable[0].starid
	endif else begin
		print,'***Error(LIST_STARID): stars not specified!'
		return
	endelse
endif
;
FOR k=0L,n_elements(starids)-1 DO BEGIN
;
starid=strupcase(starids[k])
;
found=0
;
; Check StarIDs first
if found eq 0 then begin
	i=where(StarTable.starid eq starid[0],found)
endif
;
; Check other indices
if found eq 0 then begin
	id=strmid(starid,3,6)
	if isnumeric(id) then id=long(id) else id=0
	case strmid(starid,0,3) of
	'FKV': ids=StarTable.fkv
	'BSC': ids=StarTable.bsc
	'HDN': ids=StarTable.hdn
	'FLN': ids=StarTable.fln
	'SAO': ids=StarTable.sao
	'HIC': ids=StarTable.hic
	'HIP': ids=StarTable.hic
	else : ids=-1
	endcase
	i=where(ids eq id,found)
endif
;
; Then check names
if found eq 0 then begin
	words=strupcase(nameparse(starid))
	names=strupcase(StarTable.name+StarTable.var)
	i=lindgen(n_elements(StarTable))
	for j=n_elements(words)-1,0,-1 do begin
		index=where(strpos(names,words[j]) ne -1,count)
		if count gt 0 then begin
			names=names[index]
			i=i[index]
			found=count
			stars=names[index]
		endif
	endfor
endif
;
; Check proper names
if found eq 0 then begin
	id_bsc=cri(starid,'bsc') & id_bsc=id_bsc[0]
	if id_bsc gt 0 then i=where(StarTable.bsc eq id_bsc,found)
	if found eq 0 then begin
		id_fkv=cri(starid,'fkv') & id_fkv=id_fkv[0]
		if id_fkv gt 0 then i=where(StarTable.fkv eq id_fkv,found)
	endif
endif
;
if found eq 0 then begin
	print,'***Error(LIST_STAR): star not found!'
	return
endif
;
if n_elements(stars) eq 0 then stars=StarTable.starid
j=0
if found gt 1 then begin
	print,'Ambiguous: '
	print,strcompress(stars[i]),format='(a,T20,a,T40,a)'
	read,'Enter index (first = 1): ',j
	if j eq 0 then j=1
	if j gt found then j=found
	i=i[j-1]
	found=1
endif
;
for j=0,found-1 do begin
	print,'_____________________________________________'
	print,'Star: ',strcompress(StarTable[i[j]].starid), $
		' Name: ',strcompress(StarTable[i[j]].name), $
;		' (#',i(j),StarTable(i(j)).sflag,')', $
		' (#',i(j),')', $
		format='(a,a,a,a,a,i6.6,1x,a,a)'
	print,'Var: ',StarTable[i[j]].var,format='(a,a10)'
	print,'HDN',StarTable[i[j]].hdn,' SAO',StarTable[i[j]].sao, $
		' HIC',StarTable[i[j]].hic,' WDS',StarTable[i[j]].wds, $
		format='(a,i6.6,a,i6.6,a,i6.6,a,i10.9)'
	print,'BSC',StarTable[i[j]].bsc,' FKV',StarTable[i[j]].fkv, $
		' BAT',StarTable[i[j]].bat,' FLN',StarTable[i[j]].fln, $
		' ADS',StarTable[i[j]].ads, $
		format='(a,i4.4,a,i4.4,a,i4.4,a,i4.4,a,i5.5)'
	print,'Right ascension (2000.0) = ',hms(StarTable[i[j]].ra)
	print,'Declination     (2000.0) = ',dms(StarTable[i[j]].dec)
	print,'Centennial proper motion in  RA [s] = ', $
		StarTable[i[j]].pmra,format='(a,f7.3)'
	print,'Centennial proper motion in Dec ["] = ', $
		StarTable[i[j]].pmdec,format='(a,f7.2)'
	print,'RV [km/s] = ',StarTable[i[j]].rv, $
		', PX ["] = ',StarTable[i[j]].px,' +/- ',StarTable[i[j]].pxe, $
		format='(a,f5.1,a,f6.3,a,f6.3)'
	print,'m_V = ',StarTable[i[j]].mv,', M_V = ',StarTable[i[j]].amv, $
		', Dm_V = ',StarTable[i[j]].dmv,format='(a,f5.2,a,f5.2,a,f5.2)'
	print,'(B-V) = ',StarTable[i[j]].bv,', (U-B) = ',StarTable[i[j]].ub, $
		', (R-I) = ',StarTable[i[j]].ri,format='(a,f5.2,a,f5.2,a,f5.2)'
	print,'b-y = ',StarTable[i[j]].by,', m1 = ',StarTable[i[j]].m1, $
		', c1 = ',StarTable[i[j]].c1,', b = ',StarTable[i[j]].beta, $
		format='(a,f5.2,a,f5.2,a,f5.2,a,f4.2)'
	print,'Spectrum = ',strcompress(StarTable[i[j]].spectrum), $
		', [Fe/H] = ',StarTable[i[j]].feh,format='(a,a,a,f5.2)'
	print,'Primary   = ',StarTable[i[j]].type,StarTable[i[j]].class, $
		', Secondary = ',StarTable[i[j]].type2,StarTable[i[j]].class2, $
		format='(a,f4.1,1x,f3.1,a,f4.1,1x,f3.1)'
	print,'Diameter = ',StarTable[i[j]].diameter, $
	    ', T_eff = ',long(StarTable[i[j]].teff), $
	    ', log(g) = ',StarTable[i[j]].logg, $
		format='(a,f6.3,a,i5,a,f3.1)'
	if StarTable[i[j]].bflag eq 'B' then begin
	print,'Period = ',StarTable[i[j]].p,', Epoch = ',StarTable[i[j]].t, $
		format='(a,f11.4,a,f12.4)'
	print,'Arg.periastron = ',StarTable[i[j]].o, $
		', Eccentricity = ',StarTable[i[j]].e, $
		format='(a,f5.1,a,f4.2)'
	print,'K1 = ',StarTable[i[j]].k1,', K2 = ',StarTable[i[j]].k2, $
		format='(a,f5.1,a,f5.1)'
	print,'M1sin3i = ',StarTable[i[j]].m1sin3i,', M2sin3i = ', $
		StarTable[i[j]].m2sin3i, $
		format='(a,e7.1,a,e7.1)'
	print,'a1sini = ',StarTable[i[j]].a1sini,', a2sini = ', $
		StarTable[i[j]].a2sini,format='(a,e8.2,a,e8.2)'
	print,'I = ',StarTable[i[j]].i, $
		', W = ',StarTable[i[j]].n, $
		', A [mas] = ',1000*StarTable[i[j]].a, $
		format='(a,f4.0,a,f5.1,a,f7.1)'
	endif
	print,'____________________***______________________'
	if j lt found-1 then $
		hak,mesg='More than one star: hit return to continue...'
endfor
;
if k lt n_elements(starids)-1 then $
	hak,mesg='Hit return to continue...'
ENDFOR
;
end
