pro list_stars,stars,names
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return list of stars which occur in data currently loaded.
; This list is therefore not derived from the startable!
;
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
stars=''
size_scantable=size(scantable)
if n_elements(scantable) eq 0 or size_scantable[2] ne 8 then begin
	if n_elements(scans) eq 0 then begin
		print,'***Error(LIST_STARS): neither ScanTable nor scans exist!'
		return
	endif
	starids=[scans.starid]
endif else begin
	starids=ScanTable.StarId
endelse
stars=starids[uniq(starids,sort(starids))]
size_scans=size(scans)
if n_elements(scans) gt 0 and size_scans[2] eq 8 then begin
	names=stars
	for i=0,n_elements(names)-1 do begin
		j=where(scans.starid eq stars[i],count) & j=j[0]
		if count gt 0 then $
		names[i]=scans[j].star
	endfor
endif
;
if n_params() eq 0 then begin
print,'__________________________________'
for i=0,n_elements(stars)-1 do begin
	index=where(starids eq stars[i] and scantable.code eq 1)
	ids=string(index+1,format='(i0)')+'(' $
	   +string(scantable[index].scanid,format='(i0)')+')'
	print,stars[i]+': Scans '+strjoin(ids,',')
endfor
print,'_______________***________________'
endif
;
end
