pro list_summary_amoeba
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common ModelFit,parameters,ds_options
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common AuxData,parallaxes,k1,k2,vsini
;
print,''
print,'_________________________________________________________'
if n_elements(scans) ne 0 then begin
	print,'Interferometry loaded, weight=',ds_options.i
	print,'    Number of nights:',n_elements(GeoInfo.date)
	print,'  V2',string(9B),'  VP',string(9B), $
	      '  TA',string(9B),'  TP',string(9B),'  FL'
	print,ds_options.v2 ge 1,string(9B),ds_options.vp ge 1,string(9B), $
	      ds_options.ta ge 1,string(9B),ds_options.tp ge 1,string(9B), $
	      ds_options.fl ge 1
endif
if n_elements(positions) ne 0 then begin
	print,'Astrometry loaded, weight=',ds_options.a
	print,'    Number of positions:',n_elements(positions)
	list_poscomps,poscomps
	print,'    Components: ',poscomps
endif
if n_elements(velocities) ne 0 then begin
	print,'Spectroscopy loaded, weight=',ds_options.s
	print,'    Number of velocities:',n_elements(velocities)
	list_velcomps,velcomps
	print,'    Components: ',velcomps
endif
if n_elements(magnitudes) ne 0 then begin
	print,'Photometry loaded, weight=',ds_options.p
	print,'    Number of magnitudes:',n_elements(magnitudes)
	if ds_options.pm eq 0 then print,'Photometry type: time series.'
	if ds_options.pm eq 1 then print,'Photometry type: model components.'
endif
if n_elements(parallaxes) ne 0 then begin
	if ds_options.px gt 0 then print,'Parallax set, weight=',ds_options.px
	if ds_options.px lt 0 then print,'Parallax set, value= -1'
	if ds_options.px eq 0 then print,'Parallax not set'
endif
if n_elements(k2) ne 0 then begin
	print,'K2 set, weight=',ds_options.k2
endif
if n_elements(vsini) ne 0 then begin
	print,'Vsin(i) set, weight=',ds_options.vsini
endif
print,'___________________________***___________________________'
;
end
