pro list_summary_chameleon,unit
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Print summary of observations and system configuration to screen.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
close_unit=0
if n_elements(unit) eq 0 then begin
	openw,unit,'/dev/tty',/get_lun
	close_unit=1
endif
;
if not close_unit then $
printf,unit,'The following information was obtained:' $
else $
printf,unit,format='(%"The following information was obtained:\r")'
;
if checkdata([5]) eq 0 then begin
	if not close_unit then $
	printf,unit,'UT date of observation: ',Date $
	else $
	printf,unit,format='(%"UT date of observation: %s\r")',Date
endif
if checkdata([6]) eq 0 then begin
	if not close_unit then $
	printf,unit,'System ID: ',SystemId $
	else $
	printf,unit,format='(%"System ID: %s\r")',SystemId
	if not close_unit then $
	printf,unit,'Instrument: ',instrument_id(SystemId) $
	else $
	printf,unit,format='(%"Instrument: %s\r")',instrument_id(SystemId)
endif
if checkdata([7]) eq 0 then begin
	if not close_unit then $
	printf,unit,'Location : Longitude=',GeoParms.Longitude,'E, Latitude=', $
		GeoParms.Latitude,', Altitude=',GeoParms.Altitude,'m', $
		format='(a,f6.1,a,f5.1,a,f5.0,a)' $
	else $
	printf,unit,format='(%"Location : Longitude=%6.1f E, Latitude=%5.1f, Altitude=%
		GeoParms.Longitude,GeoParms.Latitude,GeoParms.Altitude
endif
if checkdata([8]) eq 0 then begin
	if not close_unit then begin
	printf,unit,'Stations :',GenConfig.StationId[0:GenConfig.NumSid-1]
	printf,unit,'Reference station: ',GenConfig.StationId[GenConfig.RefStation-1]
	endif else begin
	printf,unit,format='(%"Stations : %s\r")', $
		strjoin(GenConfig.StationId[0:GenConfig.NumSid-1],' ')
	printf,unit,format='(%"Reference station:  %s\r")', $
		GenConfig.StationId[GenConfig.RefStation-1]
	endelse
	for i=0,GenConfig.NumOutBeam-1 do begin
	IF not close_unit THEN BEGIN
	printf,unit,'-----------------------------------------------------------'
	printf,unit,'OutputBeam No.',i+1, $
	      ', SpectrometerId: ',GenConfig.SpectrometerId[i]
	printf,unit,'Baselines: ', $
		GenConfig.BaselineId[0:GenConfig.NumBaseline[i]-1,i], $
		format='(a,15(a7,1x))'
	printf,unit,'Channels:    '
	channels=indgen(GenConfig.NumSpecChan[i])+1
	nc=n_elements(channels)
	nl=10
	if nc mod 10 eq 0 then l=0 else l=1
	for k=0,nc/10-l do $
	printf,unit,channels[k*nl:(k+1)*nl-1], $
		format='(10(i5,1x))'
	printf,unit,channels[k*10:nc-1], $
		format='(10(i5,1x))'
	printf,unit,'Lambda [nm]: '
	wavelengths= $
		fix(1.d9*GenConfig.Wavelength[0:GenConfig.NumSpecChan[i]-1,i])
	for k=0,nc/10-l do $
	printf,unit,wavelengths[k*nl:(k+1)*nl-1], $
		format='(10(i5,1x))'
	printf,unit,wavelengths[k*10:nc-1], $
		format='(10(i5,1x))'
	printf,unit,'Widths [nm]  '
	widths= $
		fix(1.d9*GenConfig.ChanWidth[0:GenConfig.NumSpecChan[i]-1,i])
	widths= $
		1.d9*GenConfig.ChanWidth[0:GenConfig.NumSpecChan[i]-1,i]
	for k=0,nc/10-l do $
	printf,unit,widths[k*nl:(K+1)*nl-1], $
		format='(10(f6.1,1x))'
;		format='(10(i5,1x))'
	printf,unit,widths[k*10:nc-1], $
		format='(10(f6.1,1x))'
;	printf,unit,fix(1.d9* $
;		GenConfig.ChanWidth(0:GenConfig.NumSpecChan(i)-1,i)), $
;		format='(10(i5,1x))'
	ENDIF ELSE BEGIN
	printf,unit,format='(%"--------------------------------------------------------
	printf,unit,format='(%"OutputBeam No. %d, SpectrometerId: %s \r")', $
		i+1,GenConfig.SpectrometerId[i]
	printf,unit,format='(%"Baselines: %s \r")', $
	strjoin(GenConfig.BaselineId[0:GenConfig.NumBaseline[i]-1,i],' ')
	printf,unit,format='(%"Channels:    \r")'
	channels=string(indgen(GenConfig.NumSpecChan[i])+1,format='(10(i5,1x))')
	if GenConfig.NumSpecChan[i] mod 10 eq 0 then l=1 else l=0
	for k=0,GenConfig.NumSpecChan[i]/10-l do printf,unit,format='(%"%s \r")',channe
;	printf,unit,format='(%"%s \r")', $
;	strjoin(string(indgen(GenConfig.NumSpecChan(i))+1,format='(10(i5,1x))'))
	printf,unit,format='(%"Lambda [nm]: \r")'
	wavelengths=string( $
		fix(1.d9*GenConfig.Wavelength[0:GenConfig.NumSpecChan[i]-1,i]), $
		format='(10(i5,1x))')
	for k=0,GenConfig.NumSpecChan[i]/10-l do printf,unit,format='(%"%s \r")',wavele
;	printf,unit,format='(%"%s \r")', $
;	strjoin(string(fix(1.d9*GenConfig.Wavelength(0:GenConfig.NumSpecChan(i)-1,i)),
;		format='(10(i5,1x))'))
	printf,unit,format='(%"Widths [nm]  \r")'
	chanwidths=string( $
;		fix(1.d10*GenConfig.ChanWidth(0:GenConfig.NumSpecChan(i)-1,i)), $
;		format='(10(i5,1x))')
		1.d9*GenConfig.ChanWidth[0:GenConfig.NumSpecChan[i]-1,i], $
		format='(10(f6.1,1x))')
	for k=0,GenConfig.NumSpecChan[i]/10-l do printf,unit,format='(%"%s \r")',chanwi
;	printf,unit,format='(%"%s \r")', $
;	strjoin(string(fix(1.d9*GenConfig.ChanWidth(0:GenConfig.NumSpecChan(i)-1,i)),
;		format='(10(i5,1x))'))
	ENDELSE
	endfor
	if not close_unit then begin
	printf,unit,'-----------------------------------------------------------'
	endif else begin
	printf,unit,format='(%"--------------------------------------------------------
	endelse
	if GenConfig.NumTriple gt 0 then begin
	tripno=strarr(3,GenConfig.NumTriple)
	tripno[0,*]='(' $
		+string(indgen(GenConfig.NumTriple)+1,format='(i2)')+') '
	if not close_unit then begin
	printf,unit,'Triple combinations:'
	printf,unit,tripno+genconfig.baselineid[ $
		genconfig.triplebase[*,0:GenConfig.NumTriple-1], $
		genconfig.triplebeam[*,0:GenConfig.NumTriple-1]]+'(' $
	+string(genconfig.triplebeam[*,0:GenConfig.NumTriple-1]+1, $
						  format='(i1)')+')'
	printf,unit,'-----------------------------------------------------------'
	endif else begin
	printf,unit,format='(%"Triple combinations:\r")'
	printf,unit,format='(%"%s\r")', $
		strjoin(tripno+genconfig.baselineid[ $
		genconfig.triplebase[*,0:GenConfig.NumTriple-1], $
		genconfig.triplebeam[*,0:GenConfig.NumTriple-1]]+'(' $
	+string(genconfig.triplebeam[*,0:GenConfig.NumTriple-1]+1, $
						  format='(i2)')+')',' ')
	printf,unit,format='(%"--------------------------------------------------------
	endelse
	endif
endif
if checkdata([1]) eq 0 then begin
	if not close_unit then begin
	printf,unit,'Number of scans recorded: ',n_elements(ScanTable)
	printf,unit,'Observations lasted from UT ', $
		hms(ScanTable[0].starttime/3600),' to ', $
		hms(ScanTable[n_elements(ScanTable)-1].stoptime/3600),' (JD ' $
		+strcompress(string(date2jd(date)+mean(ScanTable.starttime)/86400.),/remove_al
		format='(a,a,a,a,a)'
	endif else begin
	printf,unit,format='(%"Number of scans recorded: %d\r")',n_elements(ScanTable)
	printf,unit,format='(%"%s\r")','Observations lasted from UT '+ $
		hms(ScanTable[0].starttime/3600)+' to '+ $
		hms(ScanTable[n_elements(ScanTable)-1].stoptime/3600)+' (JD '+ $
		strcompress(string(date2jd(date)+mean(ScanTable.starttime)/86400.),/remove_all
	endelse
endif
;
if close_unit then free_lun,unit
;
end
