pro list_tree,indent,line
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Starting at the current level, list the HDS file structure. In case of
; array objects, this procedure will only descend the first element.
;
common ListTree,lines,do_return
;
if hds_state() eq 0 then begin
	print,'***Error(LIST_TREE): no HDS file open!'
	return
endif
;
if n_elements(indent) eq 0 then indent=-1
if n_elements(line) eq 0 then begin
	line=0
	lines=getenv('LINES')-2
	if lines le 0 then lines=22
	do_return=0
endif
;
dat_name,name
dat_type,type
dat_prim,prim
dat_shape,ndim,dims
if indent ge 0 then print,string(13b),'     ',format='(a,a,$)'
for i=1,indent do print,'     ',format='(a,$)'
if ndim gt 0 then begin
   print,name+'[',format='(a,$)'
   for i=1,ndim-1 do print,dims[i-1],'][',format='(i6,a,$)'
   print,dims[ndim-1],'] <'+strcompress(type,/remove_all)+'>',format='(i6,a,$)'
endif else print,name,' <'+strcompress(type,/remove_all)+'>',format='(a,a,$)'
for i=1,5-indent-ndim do print,'     ',format='(a,$)' & print,'          '
line=line+1
if line mod lines eq 0 then begin
	again:
	case myhak() of
		'q':	begin
			do_return=1
			return
			end
		' ':	lines=22
	string(10b):	lines=1
	       else:	goto,again
	endcase
endif
if prim eq 1 then return		; We return when object is primitive
dims=lonarr(7)+1
if ndim gt 0 then dat_cell,ndim,dims 	; We only look at the first cell!
list_names,comp_names
for i=1,n_elements(comp_names) do begin
	dat_find,comp_names[i-1]
	list_tree,indent+1,line
	dat_annul
	if do_return then begin
		if ndim gt 0 then dat_annul
		dat_name,name
		if indent lt 0 then print,string(13b), $
			'Current level = ',name,'.                             '
		return
	endif
endfor
if ndim gt 0 then dat_annul
dat_name,name
if indent lt 0 then print,string(13b), $
	'Current level = ',name,'.                             '
;
end
