function lmmotor,x,v,init=init,sid=sid,ft=ft,rh=rh,bp=bp,times=times
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
	ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common StarBase,StarTable,Notes
common LocalLMMotor,ma,tm,vcorr
;
if n_elements(init) eq 0 then init=0
if n_elements(ft) eq 0 then ft=56.3
if n_elements(rh) eq 0 then rh=33.0
if n_elements(bp) eq 0 then bp=23.316
lambda=0.650
;
RAD=180/!pi
;
if init then begin
;
	stars=strarr(n_elements(metrotime))
	for i=0,n_elements(scantable)-1 do $
		if scantable[i].starid ne 'FKV0000' then $
			stars[sol0[i]:soln[i]]=scantable[i].starid
	index=where(strlen(stars) ne 0)
	stars=stars[index]
	times=abs(metrotime[index])
	ma=reform(motorangle[*,sid-1,index])
	mae=reform(motorangleerr[*,sid-1,index])
	index=where(mae[0,*] gt 0)
	stars=stars[index]
	times=times[index]
	ma=ma[*,index]
	mae=mae[*,index]
	topostar,times,stars,startable,ra_app,dec_app
	ut1=utc2ut1(times)
	gst=ut12gst(times,ut1)
	ha=hourangle(gst,ra_app)
	hadec=refraction(natural(ha,dec_app),ft=ft,rh=rh,bp=bp)
	hadec[0,*]=hadec[0,*]*15	; convert to degrees
;
	tm=times
	v=sidmodel(sid)
	vcorr=reform(feedvector[sid-1,*,*])
	y=reform(transpose(hadec),n_elements(hadec))
	x=dindgen(n_elements(y))
	return,y
;
endif
;
n=n_elements(ma[0,*])
k=nint(x) mod n
j=nint(x) / n
;
; Compute model value
hd=sidpointing(sidmodels(v,vcorr,[1,2],tm[k]),ma[*,k],1)
hd[0]=hd[0]*15 &  hd=hd[j]
;
; These are the model parameters:
; Feed beam azimuth and elevation, siderostat azimuth and elevation,
; error in angle between axes (0=>orthogonal), zero point azimuth axis,
; tilt of mirror in its cell (0=>perpendicular) zero point elevation axis,
;
; Compute partial derivatives
pd=dblarr(8)
for i=0,7 do begin
	a=v
	a[i]=a[i]+1
	hdh=sidpointing(a,ma[*,k],1) & hdh[0]=hdh[0]*15 & hdh=hdh[j]
	a[i]=a[i]-2
	hdl=sidpointing(a,ma[*,k],1) & hdl[0]=hdl[0]*15 & hdl=hdl[j]
	pd[i]=(hdh-hdl)/2
endfor
;
return,[hd,pd]
;
end
