function lmpivot,x,v,init=init,sid=sid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; To be used with lmfit to fit pivot coordinates to the XYZ data.
;
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
	ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common LocalLMPivot,model,hadec
;
if n_elements(init) eq 0 then init=0
;
if init then begin
	v=[0.,0.,0.,0.]
	index=where(scantable.starid ne 'FKV0000' and sol0 ne -1,n)
	x=fltarr(n)
	y=fltarr(n)
	z=fltarr(n)
	m=fltarr(2,n)
;
	i=sid-1
	l=0
	for k=0,n-1 do begin
		j=where(parxerr[i,sol0[index[k]]:soln[index[k]]] gt 0,count)
		if count gt 0 then begin
			x[l]=avg(parx[i,j+sol0[index[k]]])
			y[l]=avg(pary[i,j+sol0[index[k]]])
			z[l]=avg(parz[i,j+sol0[index[k]]])
			m[*,l]=avg(motorangle[*,i,j+sol0[index[k]]],2)
			l=l+1
		endif
	endfor
	if l gt 0 then begin
		dpx=x[1:l-1]-x[0:l-2]
		dpy=y[1:l-1]-y[0:l-2]
		dpz=z[1:l-1]-z[0:l-2]
		model=sidmodel(i+1)
		hadec=sidpointing(model,m[*,0:l-1],1)
		x=findgen(n_elements(dpx)*3)
	endif else begin
		dpx=0
		dpy=0
		dpz=0
	endelse
	return,[dpx,dpy,dpz]
endif
;
n=n_elements(hadec[0,*])-1
j=nint(x) mod n
k=nint(x) / n
;
; Compute model value
mp=mirrorpivot(model,hadec[0,j:j+1],hadec[1,j:j+1],v)
dmp=mp[1,k]-mp[0,k]
;
; Compute partial derivatives
mp=mirrorpivot(model,hadec[0,j:j+1],hadec[1,j:j+1],v+[1,0,0,0])
dmpxh=mp[1,k]-mp[0,k]
mp=mirrorpivot(model,hadec[0,j:j+1],hadec[1,j:j+1],v-[1,0,0,0])
dmpxl=mp[1,k]-mp[0,k]
;
mp=mirrorpivot(model,hadec[0,j:j+1],hadec[1,j:j+1],v+[0,1,0,0])
dmpyh=mp[1,k]-mp[0,k]
mp=mirrorpivot(model,hadec[0,j:j+1],hadec[1,j:j+1],v-[0,1,0,0])
dmpyl=mp[1,k]-mp[0,k]
;
mp=mirrorpivot(model,hadec[0,j:j+1],hadec[1,j:j+1],v+[0,0,1,0])
dmpzh=mp[1,k]-mp[0,k]
mp=mirrorpivot(model,hadec[0,j:j+1],hadec[1,j:j+1],v-[0,0,1,0])
dmpzl=mp[1,k]-mp[0,k]
;
mp=mirrorpivot(model,hadec[0,j:j+1],hadec[1,j:j+1],v+[0,0,0,1])
dmpoh=mp[1,k]-mp[0,k]
mp=mirrorpivot(model,hadec[0,j:j+1],hadec[1,j:j+1],v-[0,0,0,1])
dmpol=mp[1,k]-mp[0,k]
;
return,[dmp,(dmpxh-dmpxl)/2,(dmpyh-dmpyl)/2,(dmpzh-dmpzl)/2,(dmpoh-dmpol)/2]
;
end
