pro load_astrometry,files
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common ModelFit,parameters,ds_options
;
num_files=n_elements(files)
if num_files eq 0 then begin
	print,'***Error(LOAD_ASTROMETRY): no files specified!'
	return
endif
ds_options.a=0
;
for i=0,n_elements(files)-1 do begin
	c=''
	y=0.d0
	r=0.d0
	t=0.d0
	a=0.d0
	b=0.d0
	p=0.d0
	status=dc_read_free(files[i],c,y,r,t,a,b,p, $
		/col,ignore=['!'],resize=[1,2,3,4,5,6,7])
	if status ne 0 then return
	if i eq 0 then begin
		component=c
		rho=r
		theta=t
		emajor=a
		eminor=b
		pa=p
		jy=y
	endif else begin
		component=[component,c]
		rho=[rho,r]
		theta=[theta,t]
		emajor=[emajor,a]
		eminor=[eminor,b]
		pa=[pa,p]
		jy=[jy,y]
	endelse
endfor
;
index=where(emajor lt eminor,count)
if count gt 0 then begin
	print,'***Error: major axes must be larger than minor axes!'
	return
endif
index=where(emajor eq 0 or eminor eq 0,count)
if count gt 0 then begin
	print,'***Error: one or more error ellipse axes zero!'
	return
endif
;
num_scan=n_elements(jy)
positions=replicate(location(),num_scan)
;
RAD=180/pi_circle
;
positions.component=component
positions.rho=rho
positions.theta=theta/RAD	; Note internal units of radians!
positions.emajor=emajor		; Semi-major axis of uncertainty ellipse [mas]
positions.eminor=eminor		; Semi-minor axis of uncertainty ellipse [mas]
positions.pa=pa/RAD		; Note internal units of radians!
positions.jy=jy
;
positions.jd=jy2jd(jy)-2440000d0
positions.date=jd2date(positions.jd+2440000d0)
;
; Code to fake positions
; RAD=180/3.141592653d0
; a=109.d0
; e=0.2d0
; i=32.d0/RAD
; w=99.d0/RAD
; n=30.d0/RAD
; p=974.d0
; t=5675.d0
; o_parms=dblarr(8)
; o_parms(0)=a
; o_parms(1)=e
; o_parms(2)=i
; o_parms(3)=w
; o_parms(4)=n
; o_parms(5)=p
; o_parms(6)=t
; o_parms(7)=1
; jd=positions.jd
; xy=true2app(jd,o_parms,rho,theta)
; positions.theta=theta
; positions.rho=rho
;
print,strtrim(string(n_elements(positions)),2)+' positions read.'
ds_options.a=1
end
