pro load_flagtable,table
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Load the specified flag table from a file, making sure that the other
; tables currently loaded are preserved.
;
common Hds,path,hds_file_stub
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
filename=hds_file_stub+'.flg'
result=file_search(filename,count=fcount)
if fcount ne 0 then restore,filename else begin
	print,'Warning: file not found: '+filename
	return
endelse
;
case table of
	'point':begin
		result=size(point_table) & n=n_elements(result)
		if result[n-2] eq 8 then begin
			pointflagtable=point_table
			print,'Point flagtable loaded.'
		endif else print,'Pointflagtable empty.'
		end
	'inch':	begin
		result=size(inch_table) & n=n_elements(result)
		if result[n-2] eq 8 then begin
			inchflagtable=inch_table
			print,'Inch flagtable loaded.'
		endif else print,'Inchflagtable empty.'
		end
	'bg':	begin
		result=size(bg_table) & n=n_elements(result)
		if result[n-2] eq 8 then begin
			bgflagtable=bg_table
			print,'Bg flagtable loaded.'
		endif else print,'BG flagtable empty.'
		end
	'scan':	begin
		result=size(scan_table) & n=n_elements(result)
		if result[n-2] eq 8 then begin
			scanflagtable=scan_table
			print,'Scan flagtable loaded.'
		endif else print,'Scanflagtable empty.'
		end
endcase
;
end
