pro load_photometry,files
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common ModelFit,parameters,ds_options
;
num_files=n_elements(files)
if num_files eq 0 then begin
	print,'***Error[LOAD_PHOTOMETRY]: no files specified!'
	return
endif
ds_options.p=0
;
for i=0,n_elements(files)-1 do begin
	c=''
	f=''
	hjd=0.d0
	m=0.d0
	e=0.d0
	status=dc_read_free(files[i],c,f,hjd,m,e, $
		/col,ignore=['!'],resize=[1,2,3,4,5])
	if status ne 0 then return
	if i eq 0 then begin
		component=c
		filter=f
		jd=hjd
		value=m
		error=e
	endif else begin
		component=[component,c]
		filter=[filter,f]
		jd=[jd,hjd]
		value=[value,m]
		error=[error,e]
	endelse
endfor
;
num_scan=n_elements(jd)
magnitudes=replicate(magnitude(),num_scan)
;
RAD=180/pi_circle
;
magnitudes.component=component
magnitudes.filter=filter
for i=0,num_scan-1 do magnitudes[i].wavelength=filter_cw(filter[i]) ; [nm]
magnitudes.value=value
magnitudes.error=error
magnitudes.jd=jd-2440000d0
;
magnitudes.date=jd2date(magnitudes.jd+2440000d0)
;
print,'Magnitudes read.'
if ds_options.pm eq 0 then ds_options.p=1
;
end
