pro load_spectroscopy,files
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common ModelFit,parameters,ds_options
;
num_files=n_elements(files)
if num_files eq 0 then begin
	print,'***Error[LOAD_SPECTROSCOPY]: no files specified!'
	return
endif
ds_options.s=0
;
for i=0,n_elements(files)-1 do begin
	c=''
	hjd=0.d0
	v=0.d0
	e=0.d0
	s=0
	f=0
	status=dc_read_free(files[i],c,hjd,v,e,s,f, $
		/col,ignore=['!'],resize=[1,2,3,4,5,6])
	if status ne 0 then return
	if i eq 0 then begin
		component=c
		jd=hjd
		value=v
		error=e
		symbol=s
		color=f>1
	endif else begin
		component=[component,c]
		jd=[jd,hjd]
		value=[value,v]
		error=[error,e]
		symbol=[symbol,s]
		color=[color,f>1]
	endelse
endfor
;
num_scan=n_elements(jd)
velocities=replicate(velocity(),num_scan)
;
RAD=180/pi_circle
;
velocities.component=component
velocities.value=value
velocities.error=error
velocities.jd=jd-2440000d0
velocities.symbol=symbol
velocities.color=color
;
velocities.date=jd2date(velocities.jd+2440000d0)
;
print,strtrim(string(n_elements(velocities)),2)+' velocities read.'
ds_options.s=1
end
