pro loadnight,datum,arrayid,configid,force=force
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Load specified night from memory into internal data structure scans.
; Datum can be a combination of date (YYYY-MM-DD) and config string, but
; the latter must not contain any blanks.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
datum=datum[0]
words=nameparse(datum)
datum=words[0]
if n_elements(words) eq 3 then begin
	arrayid=words[1]
	configid=words[2]
endif
if n_elements(arrayid) eq 1 then arrayid=arrayid[0]
if n_elements(configid) eq 1 then configid=configid[0]
;
; Force=1 to force reading from buffer
if n_elements(force) eq 0 then force=1 else force=force gt 0
if not force and datum eq Date then return
;
; ConfigId enables storing different configurations in the same night
if n_elements(configid) eq 0 then configid='DEFAULT'
;
Date=datum
;
j=where(GenInfo.date eq Date $
    and GeoInfo.SystemId eq arrayid $
    and GenInfo.configid eq configid,count)
if count eq 0 then begin
        set=Date+' '+arrayid+' '+configid
	print,'***Error(LOADNIGHT): this night was not stored before: '+set+'!'
	return
endif
j=j[0]
;
; This is now buffered
; GenConfig=GenInfo(j)
GeoParms=GeoInfo[j]
;
mode=20L
;
if bufferinfo[j].xdr then begin
;
; This restores both scans and GenConfig
restore,date+arrayid+configid+'.xdr'
;
endif else begin
;
GenConfig=allocGenConfig(bufferinfo[j].nigc.numsid, $
			 bufferinfo[j].nigc.numoutbeam, $
			 bufferinfo[j].nigc.maxtriple, $
			 bufferinfo[j].nigc.maxbaseline, $
			 bufferinfo[j].nigc.maxchannel, $
			 bufferinfo[j].nigc.maxconfig)
;
n=0
fields=tag_names(GenConfig)
for i=0,n_elements(fields)-1 do begin
	data=GenConfig.(i)
	dims=size(data)
;	dims=bufferinfo(j).nigc.size(i,*)
;	data=make_array(size=dims(where(dims ne 0)))
	if dims[dims[0]+1] eq 7 then begin
		blank=''
		for k=0,bufferinfo[j].nigc.maxlen(n)-1 do blank=blank+' '
		data[*]=blank
		n=n+1
	endif
	status=linknload(!external_lib,'nightbuffer', $
		dims,data,Date+arrayid+configid,mode)
	if status then begin
		print,'***Error(LOADNIGHT): error loading data!'
		print,Date+arrayid+configid
		return
	endif
	if dims[dims[0]+1] eq 7 then data=strtrim(data,2)
	GenConfig.(i)=data
endfor
;
; Note: scan() must return dimensions compatible with GenConfig!
num_scans=bufferinfo[j].nisc.numscan
scans=replicate(scan(),num_scans)
;
n=0
fields=tag_names(scans)
for i=0,n_elements(fields)-1 do begin
	data=scans.(i)
	dims=size(data)
;	dims=bufferinfo(j).nisc.size(i,*)
;	data=make_array(size=dims(where(dims ne 0)))
	if dims[dims[0]+1] eq 7 then begin
		blank=''
		for k=0,bufferinfo[j].nisc.maxlen(n)-1 do blank=blank+' '
		data[*]=blank
		n=n+1
	endif
	status=linknload(!external_lib,'nightbuffer', $
		dims,data,Date+arrayid+configid,mode)
	if status then begin
		print,'***Error(LOADNIGHT): error loading data!'
		return
	endif
	if dims[dims[0]+1] eq 7 then data=strtrim(data,2)
	scans.(i)=data
endfor
;
endelse
;
!qiet=1 & get_scantable & !qiet=0
;
Date=GeoParms.Date
SystemId=GeoParms.SystemId
;
end
