function logg_Ibsupergiant,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate log(g) [cgs] for super giants from spectral type.
; V. Straizys, "Multicolor Stellar Photometry"
;
common StarBase,startable,notes
; Super giants class Ib
s=''
t=0.
g=0.
status=dc_read_free(!oyster_dir+'starbase/spec_logg.Ib',s,t,g, $
	/col,resize=[1,2,3],ignore=['!'])
r=poly_fit(t,g,3)
;
plot=0
if plot then begin
	!p.charsize=1.5
	window,/free
	plot,findgen(70),poly(findgen(70),r),title='Super-Giants Ia', $
 		xtitle='Integer Spectral type',ytitle='log(g) [cgs]'
	oplot,t,g,psym=6
endif
;
return,poly(type,r)
;
end
