function lum_mass,mass
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Use mass-luminosity relationship for main-sequence stars to return
; luminosity (in solar units) from mass. Input data from Torres et al. 2010
; Use, e.g., l=lum_mass() to get a plot of the Torres et al. data and fit.
;
; Luminosity in solar units.
;
; New version using data from Torres et al. 2010
status=dc_read_free(!oyster_dir+'starbase/torres.dat', $
	m,em,rad,erad,teff,eteff,logg,elogg,logl,elogl,mv,emv, $
	/col,ignore=['!'])
; Exclude slightly evolved stars with log(g) < 4.3/4.1 for mass <10/>10
index=where((m le 10 and logg gt 4.3) or (m gt 10 and logg gt 4.1))
r=poly_fit(alog10(m[index]),logl[index],4,yfit)
if n_elements(mass) eq 0 then begin
	plot,alog10(m),logl,psym=1,title='Data from Torres et al. 2010', $
		xtitle='log(mass)',ytitle='log(luminosity)',charsize=1.5
	oplot,alog10(m[index]),logl[index],psym=1,color=tci(3)
	oplot,alog10(m[index]),yfit,psym=0,color=tci(3)
;	Overplot numerical relation from Allen's A. Q., p. 382
	lm=findgen(100)/50-0.5
	ll=3.8*lm+0.08
	oplot,lm,ll,psym=0,color=tci(1)
	return,0
endif else $
return,10^poly(alog10(mass),r)
;
; Old version using data from Andersen 1991
status=dc_read_free(!oyster_dir+'starbase/andersen.dat',m,lm,bv,mv,ll,lteff, $
	/col,ignore=['!'])
r=poly_fit(lm,ll,2,yfit)
return,10^poly(alog10(mass),r)
;
; From Table 4 of Eker et al. 2015
lm=alog10(mass)
logl=-0.705*lm^2+4.655*lm-0.025
return,10^logl
;
; From Allen's Astrophysical Quantities
n=60
logm=-1.0+2.5*findgen(n)/(n-1)
llum=3.8*logm+0.08
;
end
