function lum_teff,teff,radius
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute luminosity from eff. temperature and radius (Stefan-Boltzmann law),
; based on Allens's Astrophysical Quantities, p. 382, if radius specified,
; else on Boyajian et al. 2012 (equation 6), MS only!, valid for 3200 < T < 5500
; Solar units for radius. Return in solar luminosities.
;
if n_elements(radius) ne 0 then begin
;	Allens's Astrophysical Quantities, p. 382
	return,10^(2*alog10(radius)+4*alog10(teff)-4*alog10(5777))
endif else begin
;	Boyajian et al. 2012 (equation 6), valid for 3200 < T < 5500
	index=where(teff lt 3200 or teff gt 5500,count)
	if count gt 0 then $
		print,'Warning: this function only valid for 3200< T< 5500'
	logt=alog10(teff)
;
	lum=-5960.5710+4831.6912*logt-1306.9966*logt^2+117.9716*logt^3
	return,10^lum
endelse
;
end
