pro m_binaries
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Obtain mass estimate for secondary in a binary if it is not classified but
; binary is double lined. Requires primary mass, and m1/2sin(i)^3.
;
common StarBase,startable,notes
;
index=where((startable.mass ne 0) $
	and (startable.m1sin3i ne 0) $
	and (startable.m2sin3i ne 0),count)
print,'Number of double-lined single-classification binaries =',count
if count gt 0 then startable[index].mass2= $
	startable[index].mass*startable[index].m2sin3i $
			      /startable[index].m1sin3i
;
index=where((startable.mass ne 0) $
	and (startable.mf ne 0) $
	and (startable.type2 eq 0),count)
print,'Number of single-lined single-classification binaries =',count
if count gt 0 then begin
	c0=-startable[index].mass^2
	c1=-2*startable[index].mass
	c2=fltarr(count)-1
	c3=sin(!pi/4)^3/startable[index].mf
	for i=0,count-1 do begin
		s=cuberoot[[c0[i],c1[i],c2[i],c3[i]]]
		startable[index[i]].mass2=s[0]
	endfor
endif
;
end
