pro manualunwrap
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Manually unwrap the triple phase. The user places a box in the plot window,
; and +/-360 degrees is added to the data inside it.
;
common PlotDataInfo,plotscans,plotdata_x,plotdata_y
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
if ds_y.item ne 33 then begin
	print,'***Error(MANUALUNWRAP): will only unwrap TriplePhase c.!'
	return
endif
if !d.window eq -1 then begin
        print,'***Error(MANUALUNWRAP): no plot window currently open!'
        return
endif
;
icom=set_boxes(box_x,box_y)
if icom ne 4 then begin
;
	read,prompt='Add (1) or subtract (-1) 360 [degrees]? ',angle
	case angle of
		1: angle=+360.0/RAD
       	       -1: angle=-360.0/RAD
     	     else: begin
	   	   print,'***Error(MANUALUNWRAP): invalid input!'
	   	   return
	   	   end
	endcase
;
;	Start editing
	x=plotscans.x
	y=plotscans.y
	e=plotscans.ye
	ch=plotscans.ch
	tr=plotscans.tr
	pt=plotscans.pt
;
	j=where((x gt box_x[0]) and (x lt box_x[1]) and $
		(y gt box_y[2]) and (y lt box_y[1]),count)
	if count gt 0 then begin
		for i=0,count-1 do $
			scans[pt[j[i]]].triplephasec(tr[j[i]],ch[j[i]])= $
			scans[pt[j[i]]].triplephasec(tr[j[i]],ch[j[i]])+angle
		y[j]=y[j]+angle*RAD
		!p.color=tci(2)
		k=where(e[j] gt 0)
		oplot,x[j[k]],y[j[k]]
		if ps_options.e then begin
			if count gt 1 then $
				oploterr,x[j[k]],y[j[k]],e[j[k]],3 $
			else begin
				x1=x[j[0]]
				y1=y[j[0]]
				e1=e[j[0]]
				if e1 gt 0 then $
					oploterr,[x1,x1],[y1,y1],[e1,e1],3
			endelse
		endif
	endif
;
print,'Unwrapping completed. Hit <return> to continue.'
endif else icom=set_boxes(box_x,box_y,/clear)
;
end
