pro marquardt,func,x,y,sig,ndata,a,ia,ma,chisq,covar,alamda,error=error
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Iterative procedure to do non-linear least-squares fit.
;
common MarquardtFit,fit_options
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(fit_options) eq 0 then if init_marquardtfit() ne 0 then return
;
chifr=fit_options.chifr
tol=fit_options.tolerance
alamda=-fit_options.alamda
;
; Execute first iteration for setup and check of covariance matrix
chisq=0.d0
marquardtmin,x,y,sig,ndata,a,ia,ma,covar,alpha,chisq,func,alamda,tol
;
if not keyword_set(error) then begin
;
if not !quiet then print,'Running Marquardt...'
if not !quiet then print,'Initial chisq=',chisq
;
i=1
repeat begin
	chisqo=chisq
	marquardtmin,x,y,sig,ndata,a,ia,ma,covar,alpha,chisq,func,alamda,tol
	if not !quiet then print,'Iteration ',i,' completed; chisq = ',chisq
	if total(abs(covar)) eq 0 then begin
		print,'Error: covariance matrix is NULL!'
		return
	endif
	i=i+1
	chifr_crit=1.d0-chisq/chisqo lt chifr
	chisq_crit=chisq ge chisqo
	alamd_crit=(alamda gt 1)
	itera_crit=(i gt 200)
	fit_o_crit=(fit_options.o gt 0)
endrep until (1.d0-chisq/chisqo lt chifr and chisq lt chisqo) $
	or alamda gt 1 $
	or i gt 200 $
	or fit_options.o
print,'Iterations completed due to one or more of these conditions:'
if chifr_crit and not chisq_crit then begin
	print,'Convergence slow.'
	if i gt 15 then print,'To fit small diameters, start with small values!'
endif
if alamd_crit then print,'a_lambda > 1'
if itera_crit then print,'Maxmimum number of iterations reached.'
if fit_o_crit then print,'Just one iteration was requested.'
;
ny=n_elements(y)
if not !quiet then print,'Final   chisq=',chisq,', reduced = ',chisq/ny
if not !quiet then print,'Iter=',i,', Alamda=',alamda,format='(a,i2,a,f8.3)'
;
endif
;
; Compute parameter uncertainties
alamda=0.d0
marquardtmin,x,y,sig,ndata,a,ia,ma,covar,alpha,chisq,func,alamda,tol
;
end
