pro marquardt1,func,x,y,sig,ndata,a,ia,ma,chisq,covar,alamda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Iterative procedure to do non-linear least-squares fit.
; Use external library functions.
;
common MarquardtFit,fit_options
;
if n_elements(fit_options) eq 0 then if init_marquardtfit() ne 0 then return
;
covar=dblarr(ma,ma)
alpha=dblarr(ma,ma)
;
chifr=fit_options.chifr
tol=fit_options.tolerance
alamda=-fit_options.alamda
;
status=linknload(!external_lib,'marquardt_init',ma)
;
mode=10L				; The default is Marquardt-Levenberg
; if fit_options.s then mode=10L else mode=0L
; if fit_options.e then mode=mode+1	; Not used anymore in Version 8
;
chisq=0.d0
status=linknload(!external_lib,'marquardt', $
		x,y,sig,ndata,a,ia,ma,covar,alpha,chisq,func,alamda,tol,mode)
print,''
print,'Initial chisq=',chisq
;
i=1
repeat begin
	chisqo=chisq
	status=linknload(!external_lib,'marquardt', $
		x,y,sig,ndata,a,ia,ma,covar,alpha,chisq,func,alamda,tol,mode)
	i=i+1
endrep until (1-chisq/chisqo lt chifr and chisq lt chisqo) $
	or alamda gt 10 $
	or i gt 100 $
	or status ne 0 $
	or fit_options.o
print,'Final   chisq=',chisq
print,'Iter=',i,', Alamda=',alamda,', Status=',status, $
	format='(a,i2,a,f8.2,a,i1)'
;
alamda=0.d0
status=linknload(!external_lib,'marquardt', $
		x,y,sig,ndata,a,ia,ma,covar,alpha,chisq,func,alamda,tol,mode)
;
status=linknload(!external_lib,'marquardt_free',ma)
;
end
