pro marquardtdata,y,ysig,ymod,noload=noload
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return a `flat' array of the combined observed or model data sets, as
; requested per ds_options. Please note that this procedures relies
; on error bars of unobserved quantities to be negative since it does
; not check boundary information in GenConfig.
;
; Uses all loaded interferometric data, if any, unless noload=1.
; If triple amplitudes are not measured, set them equal to their model values.
; If triple phases are not measured, set them equal to their model values.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common ModelFit,parameters,ds_options
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common AuxData,parallaxes,k1,k2,vsini
;
if n_elements(noload) eq 0 then noload=0
;
y=0.d0
ysig=0.d0
ymod=0.d0
;
; Interferometry
if ds_options.i ne 0 then begin
	nights=geninfo.date
	arrays=geoinfo.systemid
	confgs=geninfo.configid
	wf=1/sqrt(ds_options.i)
	num_nights=n_elements(nights)
	if noload then num_nights=1
	for n=0,num_nights-1 do begin
		night=where(GenInfo.date eq nights[n] $
			and GeoInfo.systemid eq arrays[n] $
			and GenInfo.configid eq confgs[n])
		if n_elements(bufferinfo) gt 1 and not noload then $
		loadnight,GenInfo[night[0]].date, $
			  GeoInfo[night[0]].systemid, $
			  GenInfo[night[0]].configid
;
; 		Scan selection
		NS=n_elements(scans)
		index=indgen(NS)
		if n_elements(gen_model) ne 0 then $
		index=where(scans.starid eq gen_model.starid,NS)
		if ns gt 0 and ds_options.v2 then begin
			ndata=n_elements(scans[index].vissqc)
			y=[y,reform(scans[index].vissqc,ndata)]
			ysig=[ysig,reform(scans[index].vissqcerr,ndata)*wf]
			ymod=[ymod,reform(scans[index].vissqm,ndata)]
		endif
		if ns gt 0 and ds_options.vp then begin
			ndata=n_elements(scans[index].visphase)
			y=[y,reform(scans[index].visphase,ndata)]
			ysig=[ysig,reform(scans[index].visphaseerr,ndata)*wf]
			ymod=[ymod,reform(scans[index].visphasem,ndata)]
		endif
		if ns gt 0 and (ds_options.ta or ds_options.tp) then begin
			set_compltriple	; Fill complex triple data
			ndata=n_elements(scans[index].compltriplem)
;			New algorithm appropriate for Buscher's Theorem.
;			Rotate complex triple by closure phase
;			to match error in real part to amplitude
;			and error in imaginary part to phase.
			ct=reform(scans[index].compltriple)
			cm=reform(scans[index].compltriplem)
			cp=reform(scans[index].triplephasec)
			ce=reform(scans[index].compltripleerr)
;			Catch uninitialized bad data (option nozero used)
;			index=where(ce lt 0,count)
;			if count ge 1 then begin
;				ct(index)=0
;				cp(index)=0
;				cm(index)=0
;			endif
			if genconfig.numtriple ge 2 then begin
				ctr=reform(ct[*,0,*,*])
				cti=reform(ct[*,1,*,*])
				ct[*,0,*,*]=ctr*cos(-cp)-cti*sin(-cp)
				ct[*,1,*,*]=cti*cos(-cp)+ctr*sin(-cp)
				cmr=reform(cm[*,0,*,*])
				cmi=reform(cm[*,1,*,*])
				cm[*,0,*,*]=cmr*cos(-cp)-cmi*sin(-cp)
				cm[*,1,*,*]=cmi*cos(-cp)+cmr*sin(-cp)
				if not ds_options.ta then begin
					ct[*,0,*,*]=cm[*,0,*,*]
					ce[*,0,*,*]=-1
				endif
				if not ds_options.tp then begin
					ct[*,1,*,*]=cm[*,1,*,*]
					ce[*,1,*,*]=-1
				endif
			endif else begin
				ctr=reform(ct[0,*,*])
				cti=reform(ct[1,*,*])
				ct[0,*,*]=ctr*cos(-cp)-cti*sin(-cp)
				ct[1,*,*]=cti*cos(-cp)+ctr*sin(-cp)
				cmr=cm[0,*,*]
				cmi=cm[1,*,*]
				cm[0,*,*]=cmr*cos(-cp)-cmi*sin(-cp)
				cm[1,*,*]=cmi*cos(-cp)+cmr*sin(-cp)
				if not ds_options.ta then begin
					ct[0,*,*]=cm[0,*,*]
					ce[0,*,*]=-1
				endif
				if not ds_options.tp then begin
					ct[1,*,*]=cm[1,*,*]
					ce[1,*,*]=-1
				endif
			endelse
			y=[y,reform(ct,ndata)]
			ysig=[ysig,reform(ce,ndata)*wf]
			ymod=[ymod,reform(cm,ndata)]
		endif
	endfor
endif
;
; Astrometry
if ds_options.a ne 0 then begin
	wf=1/sqrt(ds_options.a)
	y_ra=positions.rho*sin(positions.theta)
	y_dc=positions.rho*cos(positions.theta)
	ymod_ra=positions.rhom*sin(positions.thetam)
	ymod_dc=positions.rhom*cos(positions.thetam)
	y=[y,dblarr(n_elements(positions))]
	ddc=ymod_dc-y_dc
	dra=ymod_ra-y_ra
	phi=atan(dra,ddc)-positions.pa
	if ds_options.c ge 1 then phi[*]=0
	eminor=positions.eminor
	emajor=positions.emajor
	if ds_options.c eq 2 then begin
		eminor[*]=1
		emajor[*]=1
	endif
	e=sqrt(emajor^2-eminor^2)/emajor
	ysig=[ysig,sqrt(eminor^2/(1-(e*cos(phi))^2))*wf]
	ymod=[ymod,sqrt(dra^2+ddc^2)]
endif
;
; Spectroscopy
if ds_options.s ne 0 then begin
	wf=1/sqrt(ds_options.s)
	y=[y,velocities.value]
	ysig=[ysig,velocities.error*wf]
	ymod=[ymod,velocities.valuem]
endif
;
; Photometry
if ds_options.p ne 0 then begin
	wf=1/sqrt(ds_options.p)
	y=[y,magnitudes.value]
	ysig=[ysig,magnitudes.error*wf]
	ymod=[ymod,magnitudes.valuem]
endif
;
; Auxilliary data
; Parallax, and optional enforcement of same parallax for all binary components
if ds_options.px ne 0 then begin
	wf=1/sqrt(abs(ds_options.px))
;	Scale the weight of the parallax if ds_options.px < 0
	if ds_options.px lt 0 then begin
                opt_px=ds_options.px
                ds_options.px=0
                index=where(ysig gt 0,count)
		chisq=modelchisq()
		if chisq eq 0 then chisq=1
                wf=1/sqrt(count*chisq)
                ds_options.px=opt_px
        endif
	index=where(binary_model.method eq 1,count)
	if count gt 0 then begin
		pxs=fltarr(count)
		if ds_options.px lt 0 then pxs[*]=mean(parallaxes.valuem[index])
		if ds_options.px gt 0 then pxs=parallaxes.value[index]
		y=[y,pxs]
		ysig=[ysig,parallaxes.error[index]*wf]
		ymod=[ymod,parallaxes.valuem[index]]
	endif
endif
; K1
if ds_options.k1 gt 0 then begin
	wf=1/sqrt(ds_options.k1)
	y=[y,k1.value]
	ysig=[ysig,k1.error*wf]
	ymod=[ymod,k1.valuem]
endif
; K2
if ds_options.k2 gt 0 then begin
	wf=1/sqrt(ds_options.k2)
	y=[y,k2.value]
	ysig=[ysig,k2.error*wf]
	ymod=[ymod,k2.valuem]
endif
; V sin(i)
 ds_options.vsini=0
if ds_options.vsini gt 0 then begin
	wf=1/sqrt(ds_options.vsini)
	y=[y,vsini.value]
	ysig=[ysig,vsini.error*wf]
	ymod=[ymod,vsini.valuem]
endif
;
; Edit the data
index=where(ysig gt 0,count)
if count gt 0 then begin
	y=y[index]
	ysig=ysig[index]
	ymod=ymod[index]
endif else begin
	print,'***Error(MARQUARDTDATA): no valid data found!'
	y=0
	ysig=0
	ymod=0
endelse
;
end
