function mask2pix,winv,lambda,a,flux=flux
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given polynomial coefficients describing the position of the mask, as well
; as width information, fit mask profiles to each column and return
; the values for an evaluation of how well this masks follows the
; spectrum.
;
; x0 is the reference pixel for the polynom definition: x0(PRISM)=130
; a=[a0,a1,a2], polynomial fit coefficients, a3=width in pixels
;
n=n_elements(winv)
nx=n_elements(lambda)
ny=n/nx
wina=reform(winv,nx,ny)
winf=wina
x=findgen(nx)
y=findgen(ny)
x0=a[4]
y0=poly(x-x0,a[0:2])
w=a[3]*lambda/lambda[fix(x0)]
w=a[3]+lambda*0	; no scaling with lambda
flux=fltarr(nx)
;
for j=0,nx-1 do begin
	p=reform(wina[j,*])
	gp=[max(p),y0[j],w[j]]	; parameters (first one to be fit)
	winf[j,*]=curvefit(y,p,p*0+1,gp,fita=[1,0,0], $
		function_name='funct_gauss',/noderivat)
	flux[j]=gp[0]
endfor
;
return,reform(winf,n)
;
end
