pro maskfuncs,x,y,a,ymod,ysig,dyda,ma,ndata,ia
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common FitMask,lambda,x0,phot_file,det_window,coeffs,num_bad_col,num_bad_row
;
; a: a0,a1,a2: polynomial coefficients, a3=width at x0
;
a[3]=abs(a[3])		; width must not become negative
;
deltaa=dblarr(5)
deltaa[0]=0.5		; a0, the position at x0
deltaa[1]=0.02		; a1, linear term
deltaa[2]=0.0001	; a2, quadratic term
deltaa[3]=0.1		; width
deltaa[4]=1.0		; This position corresponds to x0, which is never fit.
;
dyda=dblarr(ndata,ma)
;
b=a
;
for j=0,ma-1 do begin
	if ia[j] gt 0 then begin
		b[j]=a[j]-deltaa[j]
		y_low=mask2pix(y,lambda,b)
		b[j]=a[j]+deltaa[j]
		y_high=mask2pix(y,lambda,b)
		b[j]=a[j]
		dyda[*,j]=(y_high-y_low)/(2*deltaa[j])
	endif
endfor
;
ymod=mask2pix(y,lambda,a)
;
end
