function mass2_mf,mf,m1
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute minimum secondary mass for given velue mf of mass function and
; primary mass.
;
; Definition of mass function
; mf=m2^3*sin(i)^3/(m1+m2)^2
;
; The minimum mass estimate is for i=90
inclination=90.
;
m2=m1
;
repeat m2=(mf*(m1+m2)^2)^(1./3) until abs(mf-m2^3/(m1+m2)^2) lt 0.001
;
return,m2
;
end
