pro mass_binaries
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Applying Kepler's 3rd law to visual binaries with measured parallaxes
; and the primary spectral types, compute component masses and magnitude
; differences. Reduces the startable to just those systems!
;
common StarBase,StarTable,Notes
;
index=where(startable.px ne 0 and $
	    startable.p ne 0 and $
	    startable.type gt 0,count)
if count eq 0 then begin
	print,'***Error(MASS_BINARIES): not enough data to compute!'
	return
endif
startable=startable[index]
;
; Assume dwarfs if class is unknown
startable[where(startable.class eq 0)].class=5
;
; Set secondary class and type to unknown
type2=startable.type2
class2=startable.class2
startable.type2=0
startable.class2=0
;
; Compute total masses from parallax, a, and P
m1pm2=(startable.a/startable.px)^3/(startable.p/365.25)^2
;
; Estimate primary mass from spectral classification
mass_stars
m1=startable.mass
;
; Compute secondary mass as total minus primary mass
m2=m1pm2-m1
startable.mass2=m2
;
; Compute mass function
; Beware: f(m) from SB9 cannot be taken at face value as for example
; K1 (HIC 6564) is actually K1+k2!
startable.mf=1.0385e-7*(1.0-startable.e^2)^(3./2)*startable.k1^3*startable.p
mf=(m2*sin(startable.i*!pi/180))^3/m1pm2^2 ; should have same value as above
startable.mf=mf	; Store this value for f(m)
;
; Estimate secondary mass with mass function
; tbd...
return
;
; Estimate primary absolute magnitude from spectral classification
amv_stars
amv1=startable.amv
;
; Derive secondary (integer) spectral type
s=''
m=0.
t=0.
status=dc_read_free(!oyster_dir+'starbase/masses.V',m,t, $
	/col,resize=[1,2],ignore=['!'])
r=poly_fit(alog(m),t,5)
t2=fix(poly(alog(m2),r))
startable.type2=t2
startable.class2=5
;
; Estimate secondary absolute magnitude assuming they are dwarfs
d_type=''
d_ft=0.
d_t=0.
d_c=0.
d_mv=0.
d_mb=0.
status=dc_read_free(!oyster_dir+'starbase/spec_par.V', $
	d_type,d_ft,d_t,d_c,d_mv,d_mb, $
	/col,resize=[1,2,3,4,5],ignore=['!'])
d_r=poly_fit(d_ft,d_mv,5)
amv2=poly(t2,d_r)
;
dmv=amv2-amv1
startable.dmv=dmv
;
end
