function mass_dwarf,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate mass for dwarfs from spectral type.
;
common StarBase,startable,notes
;
s=''
m=0.
t=0.
; Schmidt-Kaler 1982
; status=dc_read_free(!oyster_dir+'starbase/spec_mass.V',s,m,t, $
; 	/col,resize=[1,2,3],ignore=['!'])
;
; Masses from Anderson 1991
status=dc_read_free(!oyster_dir+'starbase/masses.V',m,t, $
	/col,resize=[1,2],ignore=['!'])
r=poly_fit(t,alog(m),5)
;
plot=0
if plot then begin
	!p.charsize=1.5
	plot,findgen(70),poly(findgen(70),r),title='Dwarfs', $
		xtitle='Integer Spectral type',ytitle='ln(mass)'
	oplot,t,alog(m),psym=6
endif
;
return,exp(poly(type,r))
;
end
