function mass_giant,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate mass for giants from spectral type.
;
common StarBase,startable,notes
;
s=''
m1=0.
t1=0.
; Schmidt-Kaler 1982
status=dc_read_free(!oyster_dir+'starbase/spec_mass.III',s,m,t, $
	/col,resize=[1,2,3],ignore=['!'])
r=poly_fit(t,alog(m),3)
;
plot=0
if plot then begin
	!p.charsize=1.5
	plot,findgen(70),poly(findgen(70),r),title='Giants', $
 		xtitle='Integer Spectral type',ytitle='ln(mass)'
	oplot,t,alog(m),psym=6
endif
;
return,exp(poly(type,r))
;
end
