pro mass_stars,extended
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compound procedure to estimate stellar masses for all spectral types.
; Store results in startable.
;
common StarBase,startable,notes
;
; If extended=1, allow floating point types.
if n_elements(extended) eq 0 then extended=0 else extended=extended gt 0
;
index=dwarfs(startable.class,startable.type,extended)
if index[0] ne -1 then $
	startable[index].mass=mass_dwarf(startable[index].type)
index=dwarfs(startable.class2,startable.type2,extended)
if index[0] ne -1 $
	then startable[index].mass2=mass_dwarf(startable[index].type2)
;
index=subgiants(startable.class,startable.type)
if index[0] ne -1 then $
	startable[index].mass=mass_subgiant(startable[index].type)
index=subgiants(startable.class2,startable.type2)
if index[0] ne -1 then $
	startable[index].mass2=mass_subgiant(startable[index].type2)
;
index=giants(startable.class,startable.type,extended)
if index[0] ne -1 then $
	startable[index].mass=mass_giant(startable[index].type)
index=giants(startable.class2,startable.type2,extended)
if index[0] ne -1 then $
	startable[index].mass2=mass_giant(startable[index].type2)
;
index=brightgiants(startable.class,startable.type)
if index[0] ne -1 then $
	startable[index].mass=mass_brightgiant(startable[index].type)
index=brightgiants(startable.class2,startable.type2)
if index[0] ne -1 then $
	startable[index].mass2=mass_brightgiant(startable[index].type2)
;
index=supergiants(startable.class,startable.type,extended)
if index[0] ne -1 then $
	startable[index].mass=mass_supergiant(startable[index].type)
index=supergiants(startable.class2,startable.type2,extended)
if index[0] ne -1 then $
	startable[index].mass2=mass_supergiant(startable[index].type2)
;
end
