function mass_subgiant,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate mass for subgiants from spectral type. Very uncertain!
;
common StarBase,startable,notes
;
s=''
m=0.
t=0.
status=dc_read_free(!oyster_dir+'starbase/spec_mass.IV',s,m,t, $
	/col,resize=[1,2,3],ignore=['!'])
;
; Read this table as the sub-giant masses are more like the dwarfs? (CHU 2017)
status=dc_read_free(!oyster_dir+'starbase/spec_mass.V',s,m,t, $
	/col,resize=[1,2,3],ignore=['!'])
;
r=poly_fit(t,alog(m),5)
;
plot=0
if plot then begin
	!p.charsize=1.5
	plot,findgen(70),poly(findgen(70),r),title='Sub-Giants', $
 		xtitle='Integer Spectral type',ytitle='ln(mass)'
	oplot,t,alog(m),psym=6
endif
;
return,exp(poly(type,r))
;
end
