function mass_vcp,mv,bv,px
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate mass from proximity of star to stellar tracks in Teff/Lum plane.
; Tracks are taken from Schaller et al. 1992 models.
;
; mv=V, bv=(B-V), px=parallax ["]
;
amv=mv-(-5+5*alog10(1./px))
teff=teff_bv(bv)
mbol=amv+bc_teff(teff)
llum=-(mbol-4.74)/2.5
ltff=alog10(teff)
;
restore,!oyster_dir+'starbase/tracks.xdr'
logl=float(logl)
logt=float(logt)
;
d=sqrt((logl-llum)^2+(logt-ltff)^2)
index=where(d eq min(d))
print,'Derived log(lum), log(Teff):',llum,ltff
print,'Track   log(lum), log(Teff):',logl[index[0]],logt[index[0]]
;
return,mass[index]
;
end
