pro medianbg
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; A more robust procedure to flag all bad channels using channelindex
; and to replace background values in each channel with the median of
; that channel.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
for i=0,GenConfig.NumOutBeam-1 do begin
	bad_channels=channelindex(genconfig.spectrometerid[i],/bad)-1
	if bad_channels[0] ge 0 then $
		bgscans[*].RateErr(i,bad_channels)= $
	   -abs(bgscans[*].RateErr(i,bad_channels))
for j=0,GenConfig.NumSpecChan[i]-1 do begin
	index=where(bgscans.RateErr[i,j] gt 0,count)
	if count gt 0 then begin
		v=medianve(bgscans[index].Rate(i,j),e)
		bgscans.Rate[i,j]=v
		if n_elements(e) eq 0 then e=sqrt(v)
		bgscans.RateErr[i,j]=e
	endif
;
endfor
endfor
;
; Inform about bad channels
for i=0,genconfig.numoutbeam-1 do begin
dead_channel_index=total(reform(bgscans.rateerr[i,*] > 0),2)
index=where(dead_channel_index eq 0,count)
if count gt 1 then s='s' else s=''
if count ge 1 then $
print,'Warning(MEDIANBG): ' $
	+string(count,format='(i3)')+' bad channel'+s+' in beam ' $
	+string(i+1,format='(i1)')+': '+string(index+1,format='(i2)')
endfor
;
print,'BG data processed.'
;
end
