pro medianob,cal=cal,all=all
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Use to support calibration of AMBER, GRAVITY or MATISSE in MR or HR modes.
;
; Run VisSqEC visibilities and phases through median filter to remove
; noise that would be added to the calibrated visibilities and phases.
;
; Only VisSqE and VisSqEC can be easily recreated with calcviscal
; from VisSq and VisSqC.
;
; Also compute a median for TripleAmpEC and TriplePhaseC(!).
;
; Initialize vissq and triple model values to the median values as well
; to allow their use in procedure outliers.
;
; If keyword cal is set, then only apply median filter to calibrator scans.
; If keyword all is set, apply median filter also to VisSq and VisSqC
;
; The default is to apply the median filter VisSqE and VisSqEC of all scans.
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(cal) eq 0 then cal=0
if n_elements(all) eq 0 then all=0
;
mc=100	; Do not run median filter if spectrometer is not MR or HR
m=mc/10	; Number of samples in median
;
; Recreate VisSqE and VisSqEC
calcviscal
;
; Obtain index into selected scans corresponding to calibrator selection
if cal then begin
	index=where(startable.bflag eq 'C',count)
	if count gt 0 then begin
		cal_stars=startable[index].starid
		calscan_index=intarr(n_elements(scans))
		for k=0,n_elements(calscan_index)-1 do begin
			index=where(cal_stars eq scantable[k].starid,n)
			if n eq 0 then calscan_index[k]=-1
		endfor
		s_index=where(calscan_index ge 0)
		print,'Applying filter to '+startable[index].starid
	endif else begin
		print,'No calibrators defined in StarTable!'
		return
	endelse
endif else begin
	s_index=indgen(n_elements(scans))
endelse
;
for i=0,genconfig.numoutbeam-1 do begin
for l=0,genconfig.numbaseline[i]-1 do begin
for k=0,n_elements(s_index)-1 do begin
;
nc=genconfig.numspecchan[i]
;
; Default: process vissqe and vissqec
vissqec=reform(scans[s_index[k]].vissqec(i,0:nc-1,l))
vissqecerr=reform(scans[s_index[k]].vissqecerr(i,0:nc-1,l))
index=where(vissqecerr gt 0,count)
if count ge m and nc gt mc then begin
	scans[s_index[k]].vissqec(i,index,l)=median(vissqec[index],m)
	scans[s_index[k]].vissqec(i,index[0:m-1],l)= $
		median(vissqec[index[0:m-1]])
	scans[s_index[k]].vissqec(i,index[count-m:count-1],l)= $
		median(vissqec[index[count-m:count-1]])
;	Model values
	scans[s_index[k]].vissqm(i,index,l)= $
		scans[s_index[k]].vissqec(i,index,l)
endif
vissqe=reform(scans[s_index[k]].vissqe(i,0:nc-1,l))
vissqeerr=reform(scans[s_index[k]].vissqeerr(i,0:nc-1,l))
index=where(vissqeerr gt 0,count)
if count ge m and nc gt mc then begin
	scans[s_index[k]].vissqe(i,index,l)=median(vissqe[index],m)
	scans[s_index[k]].vissqe(i,index[0:m-1],l)= $
		median(vissqe[index[0:m-1]])
	scans[s_index[k]].vissqe(i,index[count-m:count-1],l)= $
		median(vissqe[index[count-m:count-1]])
endif
;
if all then begin
;	Also process vissq...
	vissq=reform(scans[s_index[k]].vissq(i,0:nc-1,l))
	vissqerr=reform(scans[s_index[k]].vissqerr(i,0:nc-1,l))
	index=where(vissqerr gt 0,count)
	if count gt m and nc gt mc then begin
	scans[s_index[k]].vissq(i,index,l)=median(vissq[index],m)
	endif
;	...and vissqc
	vissqc=reform(scans[s_index[k]].vissqc(i,0:nc-1,l))
	vissqcerr=reform(scans[s_index[k]].vissqcerr(i,0:nc-1,l))
	index=where(vissqcerr gt 0,count)
	if count gt 0 and nc gt mc then begin
	scans[s_index[k]].vissqc(i,index,l)=median(vissqc[index],m)
	endif
endif
;
endfor
endfor
endfor
;
; Triple products
for k=0,n_elements(s_index)-1 do begin
for i=0,genconfig.numtriple-1 do begin
	nc=genconfig.triplenumchan[i]
	tripleampec=reform( $
		scans[s_index[k]].tripleampec(i,0:nc-1))
	tripleampecerr=reform( $
		scans[s_index[k]].tripleampecerr(i,0:nc-1))
	triplephasec=reform( $
		scans[s_index[k]].triplephasec(i,0:nc-1))
	triplephasecerr=reform( $
		scans[s_index[k]].triplephasecerr(i,0:nc-1))
	index=where(tripleampecerr gt 0,count)
	if count gt m and nc gt mc then begin
	scans[s_index[k]].tripleampec(i,index)=median(tripleampec[index],m)
	scans[s_index[k]].tripleampec(i,index[0:m-1])= $
		median(tripleampec[index[0:m-1]])
	scans[s_index[k]].tripleampec(i,index[count-m:count-1])= $
		median(tripleampec[index[count-m:count-1]])
;	Model values
	scans[s_index[k]].tripleampm(i,index)= $
		scans[s_index[k]].tripleampec(i,index)
;	TriplePhaseC will be overwritten only if cal=1!
	if cal then begin
	scans[s_index[k]].triplephasec(i,index)=median(triplephasec[index],m)
	scans[s_index[k]].triplephasec(i,index[0:m-1])= $
;		median(scans(s_index(k)).triplephasec(i,index(0:m-1)))
		median(triplephasec[index[0:m-1]])
	scans[s_index[k]].triplephasec(i,index[count-m:count-1])= $
;		median(scans(s_index(k)).triplephasec(i,index(count-m:count-1)))
		median(triplephasec[index[count-m:count-1]])
;	Model values
	scans[s_index[k]].triplephasem(i,index)= $
		scans[s_index[k]].triplephasec(i,index)
	endif else begin
;	Overwrite TriplePhase if cal=0
	scans[s_index[k]].triplephase(i,index)=median(triplephasec[index],m)
	scans[s_index[k]].triplephase(i,index[0:m-1])= $
;		median(scans(s_index(k)).triplephasec(i,index(0:m-1)))
		median(triplephasec[index[0:m-1]])
	scans[s_index[k]].triplephase(i,index[count-m:count-1])= $
;		median(scans(s_index(k)).triplephasec(i,index(count-m:count-1)))
		median(triplephasec[index[count-m:count-1]])
;	Model values
	scans[s_index[k]].triplephasem(i,index)= $
		scans[s_index[k]].triplephase(i,index)
	endelse
	endif
;
	if all then begin
	tripleampe=reform( $
		scans[s_index[k]].tripleampe(i,0:nc-1))
	tripleampeerr=reform( $
		scans[s_index[k]].tripleampeerr(i,0:nc-1))
	index=where(tripleampeerr gt 0,count)
	if count gt m and nc gt mc then begin
	scans[s_index[k]].tripleampe(i,index)=median(tripleampe[index],m)
	scans[s_index[k]].tripleampe(i,index[0:m-1])= $
		median(tripleampe[index[0:m-1]])
	scans[s_index[k]].tripleampe(i,index[count-m:count-1])= $
		median(tripleampe[index[count-m:count-1]])
	endif
	endif
endfor
endfor
;
end
