function medianve,y,e
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return median and error (+/-e contains 2/3 of values)
; For a Gaussian distribution, e=sigma (sigma is the standard dev.)
;
n=n_elements(y)
if n eq 0 then return,0
si=sort(y)
ys=y[si]
if n mod 2 eq 1 then v=ys[(n-1)/2] else v=(ys[n/2]+ys[n/2-1])/2
if n ge 3 then e=(ys[n/2+n/3]-ys[n/2-n/3])/2
if n eq 2 then e=(max(y)-min(y))/2
if n eq 1 then e=0.
;
return,v
end
