function merge_startable,table1,table2
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Merge two star tables and return unique result.
; (The presently loaded startable is not affected.)
;
; Note that table1 entries take precedence if duplicate.
;
common StarBase,StarTable,Notes
;
if n_elements(StarTable) ne 0 then table=StarTable
;
create_startable,[table1.starid,table2.starid],/quiet
new_table=StarTable
if n_elements(table) ne 0 then StarTable=table
;
sortkey=[table1.starid+'2',table2.starid+'1']
for i=0,n_tags(new_table)-1 do begin
	if n_elements(size(new_table.(i),/dim)) eq 1 then $
		new_table.(i)=[table1.(i),table2.(i)]
	if n_elements(size(new_table.(i),/dim)) eq 2 then $
		new_table.(i)=[[table1.(i)],[table2.(i)]]
endfor
index=uniq(new_table.starid,sort(sortkey))
return,new_table[index]
;
end
