pro metrocorr
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Use the INCHWORM solution data in ParX,-Y,-Z to compute delay correction.
; Remember that the metrology data is in units of microns. Store in MetroPos.
;
common StarBase,startable,notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if checkdata([3,8,11,16,21]) ne 0 then return
;
print,'MetroCorr begins...'
;
RAD=180/pi_circle
;
; Do we want a plot?
do_plot=0
;
; Allocate data
MetroPos=fltarr(GenConfig.NumSid,n_elements(PointTime))
MetroPosErr=fltarr(GenConfig.NumSid,n_elements(PointTime))-1
;
metrotimes=abs(MetroTime)
pointtimes=abs(PointTime)
;
; Go through available point data one scan at a time
FOR i=0,n_elements(Iscan)-1 DO BEGIN
;
index=where(metrotimes ge pointtimes[Rec0[i]] $
	and metrotimes le pointtimes[RecN[i]],count)
;
if count eq 0 then begin
	print,'Warning(METROCORR): no data for scan ',Iscan[i],'!'
	goto,DONEXT
endif
;
times=MetroTime[index]
solx=ParX[*,index]
soly=ParY[*,index]
solz=ParZ[*,index]
solxerr=ParXErr[*,index]
solyerr=ParYErr[*,index]
solzerr=ParZErr[*,index]
;
index=where(times gt 0,count)
;
if count eq 0 then begin
	print,'Warning(METROCORR): no data for scan ',Iscan[i],'!'
	goto,DONEXT
endif
times=times[index]
solx=solx[*,index]
soly=soly[*,index]
solz=solz[*,index]
solxerr=solxerr[*,index]
solyerr=solyerr[*,index]
solzerr=solzerr[*,index]
;
stars=strarr(count) & stars[*]=ScanTable[Iscan[i]-1].starid
;
; Compute apparent star positions
topostar,times,stars,startable,ra_app,dec_app
;
; Compute UT1
ut1=utc2ut1(times)
;
; Compute Greenwich apparent sidereal time
gst=ut12gst(times,ut1)
;
; Compute hour angle
ha=hourangle(gst,ra_app)
;
for j=0,GenConfig.NumSid-1 do begin
;
; 	Deal with FKV0000, i.e. the white light source, alias Alpha Lab
	index=where(stars eq 'FKV0000',count_white)
	if count_white gt 0 then begin
		hadec=equatorial2hadec( $
		      horizon2equatorial( $
		      azel2horizon(MetroConfig.SidModel.FeedbeamAng[*,j])))
		ha[index]=hadec[0]	; Should be about 5.0
		dec_app[index]=hadec[1]	; Should be about 11.7
	endif
;
	index=where(solxerr[j,*] gt 0,count)
	if count gt 1 then begin
	t=times[index]
	d=catseyedelay(MetroConfig.SidModel.FeedbeamAng[*,j], $
		       solx[j,index],soly[j,index],solz[j,index], $
		       ha[index],dec_app[index], $
		       MetroConfig.SidModel.CatsEyeOff[j], $
		       solxerr[j,index],solyerr[j,index],solzerr[j,index],e)
	if count_white gt 0 then begin
		stars_e=stars[index]
		index=where(stars_e eq 'FKV0000',count)
		if count gt 0 then begin
			d[index]=d[index]/2
			e[index]=e[index]/2
		endif
	endif
	w=1/e^2
	r=poly_fit(t,d,1,measure_errors=e,yfit=yft,yband=ybd,sigma=sig,covar=mat)
;	MetroPos(j,Rec0(i):RecN(i))=poly(pointtimes(Rec0(i):RecN(i)),r)
	MetroPos[j,Rec0[i]:RecN[i]]=spline(t,d,pointtimes[Rec0[i]:RecN[i]])
	MetroPosErr[j,Rec0[i]:RecN[i]]=sig
;
	if do_plot then begin
	plot,pointtimes[rec0[i]:recn[i]]/3600,MetroPos[j,rec0[i]:recn[i]], $
		xtitle='UT [h]',ytitle='c [microns], Sid'+string(j+1), $
		title='Scan'+string(Iscan[i]),psym=3,charsize=1.5
	oplot,t/3600,d,psym=1
	oploterr,t/3600,d,e,3
	xyouts,0.01,0.01,'Sigma='+string(sig),/normal
	endif
;
	endif
endfor
;
DONEXT:
ENDFOR
;
; Convert to "pos" format
for j=0,GenConfig.NumSid-1 do begin
	if j ne GenConfig.RefStation-1 then $
	MetroPos[j,*]=MetroPos[j,*]-MetroPos[GenConfig.RefStation-1,*]
endfor
;
print,'Finished MetroCorr computation.'
;
end
