pro mf_binaries,p,k1,e
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute mass function from measured quantities P, K, and e of single lined
; binaries.
;
common StarBase,startable,notes
;
G=6.673e-11
m_Sun=2.0e30
;
if n_params() eq 0 then begin
	index=where(startable.mass ne 0 and startable.k1 ne 0,count)
	index=where(startable.p ne 0 and startable.k1 ne 0,count)
	if count gt 0 then begin
		p_SI=startable.p*86400.
		k_SI=startable.k1*1e3
		e=startable.e
		startable[index].mf=(p_SI*k_SI^3*(1-e^2)^(3./2)/(2*!pi*G))/M_Sun
	endif
	return
endif
;
p_SI=p*86400.
k_SI=k1*1e3
;
if n_params() eq 3 then print,(p_SI*k_SI^3*(1-e^2)^(3./2)/(2*!pi*G))/M_Sun
;
end
