function mft,image,c,u,v,ci,rt,rf,ch,normalize=normalize
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given a map and coordinates (u,v), add to the complex visibilities
; the direct Fourier transform of the map evaluated at (u,v) and return
; the result. (u,v) can be vectors. Normalization is only necessary for
; the computation of visibilities, but for the computation of a difference
; map, only correlated fluxes should be compared.
;
if n_elements(normalize) eq 0 then normalize=0
;
if n_elements(ch) eq 0 then ch=0
;
uci=unique(ci)
nc=n_elements(uci)
if ch ge 1 then index=where(ci eq uci[ch-1]) $
	   else index=lindgen(n_elements(ci))
mv=c[index]
uc=u[index]
vc=v[index]
cj=ci[index]
uci=unique(cj)
nc=n_elements(uci)
;
cl=image.maps[ch].map
index=where(cl ne 0,count)
if count eq 0 then begin
	print,'No clean components!'
	return,-1
endif
cl=cl[index]
et=image.teff[index]
x=image.x[index]
y=image.y[index]
ir=where(rt ne 0,nr)
;
tf=abs(mv)*0
for i=0L,n_elements(cl)-1 do begin
	p=2*!pi*(uc*x[i]+vc*y[i])
	m=where(rt[ir] eq et[i]) & m=m[0]
	for j=0,nc-1 do begin
		f=(rf[j,m]/total(rf[j,ir]))*cl[i]
		f=rf[j,m]*cl[i]
		n=where(cj eq uci[j])
		tf[n]=tf[n]+f
		mv[n]=mv[n]+f*complex(cos(p[n]),sin(p[n]))
	endfor
endfor
;
if normalize then return,mv/tf $
             else return,mv
;
end
