function mirrorangle,ha,dec
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return mirror angle in degrees. Input HA is in hours, DEC in degrees.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
rad=180/pi_circle
ha_r=ha*(15/rad)
dec_r=dec/rad
case system_id(SystemId) of
	'NPOI'    :begin
		   feed_angle=18.5/rad
		   feed_x=-cos(feed_angle)
		   feed_y= 0
		   feed_z=+sin(feed_angle)
		   x=-cos(dec_r)*sin(ha_r)
		   z=+cos(dec_r)*cos(GeoParms.Latitude/rad)*cos(ha_r) $
		     +sin(dec_r)*sin(GeoParms.Latitude/rad)
		   ma=rad*acos(feed_x*x+feed_z*z)
		   if n_elements(ma) eq 1 then return,ma[0] else return,ma
		   end
	      else:begin
		   ma=rad*acos(-sin(ha_r)*cos(dec_r))
		   if n_elements(ma) eq 1 then return,ma[0] else return,ma
		   end
endcase
;
end
