function mirrornormal,model,ha,dec
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Mirror normal in XYZ-coordinates (right-handed, X east, Y north, Z up):
; Input HA is in hours, DEC in degrees.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
rad=180/pi_circle
ha_r=ha*(15/rad)
dec_r=dec/rad
longitude=polarmotion(-geoparms.longitude/15,latitude)
;
; Feed vector, originating at siderostat mirror
feed_az=model[0]/rad; about 88.5 deg, i.e. pointing towards West
feed_el=model[1]/rad; about 18.5 deg, i.e. beam rises towards NAT mirror
feed_x=-sin(feed_az)*cos(feed_el)
feed_y=+cos(feed_az)*cos(feed_el)
feed_z=+sin(feed_el)
;
; Star vector
x=-cos(dec_r)*sin(ha_r)
y=+sin(dec_r)*cos(Latitude/rad) $
  -cos(dec_r)*sin(Latitude/rad)*cos(ha_r)
z=+cos(dec_r)*cos(Latitude/rad)*cos(ha_r) $
  +sin(dec_r)*sin(Latitude/rad)
;
; Mirror normal
m1=(feed_x+x)
m2=(feed_y+y)
m3=(feed_z+z)
length=sqrt(m1^2+m2^2+m3^2)
m1=m1/length
m2=m2/length
m3=m3/length
;
return,[[m1],[m2],[m3]]
;
end
