function mirrorpivot,model,ha,dec,v
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return coordinates, in X(east)Y(north)Z(up) system, of catseye center given a
; specific siderostat pointing. The offset of the catseye center from the
; pivot is given by vector v, in a coordinate system of the mirror which is
; defined to be identical to the XYZ system if the mirror is pointing exactly
; west. In this orientation, the D coord. (axis offset) also increases east.
; The coordinates of the unit vectors of the mirror system in the XYZ
; system are derived from the mirror normal (identical to the X axis at the
; reference orientation), and the vectors orthogonal to it and the azimuth and
; elevation axes, respectively. Then the coordinates are given by the vector
; sum of the unit vectors times the coordinates of v.
;
mn=-mirrornormal(model,reform([ha]),reform([dec]))
mp=mn
az=[0,0,1.0]
for i=0,n_elements(ha)-1 do begin
;	Contribution from vector mirror-catseye
	el=kreuzprodukt(mn[i,*],az,/n)
	mp[i,*]=mn[i,*]*v[0] $
	       +kreuzprodukt(az,mn[i,*],/n)*v[1] $
	       +kreuzprodukt(el,mn[i,*],/n)*v[2]
;	Contribution from vector az-axis el-axis offset
	mp[i,*]=mp[i,*]+kreuzprodukt(az,el,/n)*v[3]
endfor
;
return,mp
;
; This is another method, which applies the rotation to the
; unit vectors in the opposite sense, and then determines
; the coordinates of the fixed catseye offset vector using
; its dot product with the rotated unit vectors. Rotations
; by angle alpha around the Y axis, then beta around the
; Z (i.e. azimuth) axis will result in coordinates
; [cos(a)*cos(b),cos(a)*sin(b),-sin(a)] for the CC. Applying
; the same rotations in the opposite sense first by -alpha
; and then -beta around the rotated Z axis will result in
; coordinates [cos(a)*cos(b),-sin(b),sin(a)cos(b)].
;
mn=-mirrornormal(model,ha,dec)
mp=mn
az=[0,0,1.0]
for i=0,n_elements(ha)-1 do begin
	x=mn[i,*]
	x[1]=-(mn[i,1]/sqrt(1.-mn[i,2]^2))
	x[2]=-mn[i,2]*sqrt(1.-x[1]^2)
	z=kreuzprodukt(x,[0,1.,0],/n)
	y=kreuzprodukt(z,x,/n)
	mp[i,*]=[total(v*x),total(v*y),total(v*z)]
endfor
;
return,mp
;
end
